
#ifndef HID_H
#define HID_H

#include "USBHost.h"

#ifndef u8
typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned long u32;

typedef char s8;
typedef short s16;
typedef char s32;
#endif




enum mode{ INPUT=0x81, OUTPUT=0x91, FEATURE=0xB1};

typedef struct
{
 u8 Usage;
 u8 LocalMinimun;
 u16 LocalMaximun;
 u8 ReportCount;
 u8 ReportSize;
 mode coll_mode; //INPUT/OUTPUT//FEATURE.
 u8 mode_value; 
}Report;

typedef struct
{
u8 numberofreports;
Report* pFirstReport;
//All the reports must be allocated in an array
//so they can be accessed easily.
}Collection;

///////////////////////////////////////////////////////////////////////



/* 
 * Constants
 */
 #define PATH_SIZE               10 
 #define USAGE_TAB_SIZE          50 
 #define MAX_REPORT             300
 #define REPORT_DSC_SIZE       6144

 #define SIZE_0                0x00
 #define SIZE_1                0x01
 #define SIZE_2                0x02
 #define SIZE_4                0x03
 #define SIZE_MASK             0x03


 #define TYPE_MAIN             0x00
 #define TYPE_GLOBAL           0x04
 #define TYPE_LOCAL            0x08
 #define TYPE_MASK             0x0C
 
/* Main items */
 #define ITEM_COLLECTION       0xA0
 #define ITEM_END_COLLECTION   0xC0
 #define ITEM_FEATURE          0xB0
 #define ITEM_INPUT            0x80
 #define ITEM_OUTPUT           0x90


 /* Global items */
 #define ITEM_UPAGE            0x04
 #define ITEM_LOG_MIN          0x14
 #define ITEM_LOG_MAX          0x24
 #define ITEM_PHY_MIN          0x34
 #define ITEM_PHY_MAX          0x44
 #define ITEM_UNIT_EXP         0x54
 #define ITEM_UNIT             0x64
 #define ITEM_REP_SIZE         0x74
 #define ITEM_REP_ID           0x84
 #define ITEM_REP_COUNT        0x94
 
 /* Local items */
 #define ITEM_USAGE            0x08
 #define ITEM_STRING           0x78
 
 /* Long item */
 #define ITEM_LONG       0xFC
 
 #define ITEM_MASK             0xFC
 
 /* Attribute Flags */
 #define ATTR_DATA_CST         0x01
 #define ATTR_NVOL_VOL         0x80
 


typedef struct
{
u8 UPage;
u8 Usage;
}HIDNode;

typedef struct
{
 u8 Size;
 HIDNode Node[PATH_SIZE];
 }HIDPath;
 

typedef struct
{
    u32 Value;
    HIDPath Path;
    u8 ReportID;
    u8 Offset;
    u8 Size;
    u8 Type;
    u8 Attribute;
    u32 Unit;
    u8 UnitExp;
    u32 LogMin;
    u32 LogMax;
    u32 PhyMin;
    u32 PhyMax;
    } HIDData;

typedef struct
{
 u8 ReportDesc[REPORT_DSC_SIZE];
 u8 ReportDescSize;
 u8 Pos;
 u8 Item;
 u32 Value;
 HIDData Data;
 u8 OffsetTab[MAX_REPORT][3];
 u8 ReportCount;
 u8 Count;
 u8 UPage;
 HIDNode UsageTab[USAGE_TAB_SIZE];
 u8 UsageSize;
 u8 nObject;
 u8 nReport;
 } HIDParser;
 


int HIDParse(HIDParser* pParser,HIDData* pData);
void ResetParser(HIDParser* pParser);
int FindObject(HIDParser* pParser, HIDData* pData);
void GetValue(const u8* Buff, HIDData* pData);
void SetValue(const HIDData* pData, u8* Buf);
u8* GetReportOffset(HIDParser* pParser, const u8 ReportID, const u8 ReportType);








#endif 