#include "mbed.h"

AnalogIn input(p20); //the range of the analog input goes, from 0 V. to 3.3V.
// the actual value is represented as a float from 0 to 1.

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);



int main() {


    float ain; //ain must be a float, for matching the input.read type.

    while (1) {

        ain=input.read();

        if (ain<0.15) {                  //if analog input <0.15*3.3=0.45V
            led1=0;
            led2=0;
            led3=0;
            led4=0;
        } else if ( ain>0.15 && ain<0.3) {  // ain>0.45V and ain< 0.99V
            led1=1;
            led2=0;
            led3=0;
            led4=0;
        } else if ( ain>0.3 && ain<0.6) { // ain>0.99V and ain<1.98V
            led1=1;
            led2=1;
            led3=0;
            led4=0;
        } else if ( ain>0.6 && ain<0.91) {  //ain>1.98 and ain>3.01V
            led1=1;
            led2=1;
            led3=1;
            led4=0;
        } else {                          // more that 3 volts.
            led1=1;
            led2=2;
            led3=1;
            led4=1;
        }


    }//end while(1)
}//end main