//It is the code of the GPRS communication by the use of the Sim800 module.
//This code has work is "to upload data on data.sparkfun.com in every 5 seconds.
//To check the uploaded data the URL is "data.sparkfun.com/streams/roYVdJgWrXUpxVpDYJpA".
 
#include "mbed.h"
#include <string> 
#include "SDBlockDevice.h"
#include "FATFileSystem.h"
#include "Base64.h"

#define GSMRX PA_9
#define GSMTX PA_10 
#define SAMPLE_FLAG1 (1UL << 0)
#define SAMPLE_FLAG2 (1UL << 9)
#define BUFFER_SIZE 50

typedef struct {
uint8_t *lcdData;
char logMessage;      
} message_t;
//Инициализация ивентов и очереди
Queue<message_t, 32> queue;
MemoryPool<message_t, 100> mpool;
EventQueue evq;
EventQueue sdEvent;
//Инициализация потоков
Thread eventThread;
Thread gsmTask;
Thread sdEventThread;
Thread sdLogWrite;
//Флаги
int timeCounter = 0;
int c;
bool pressedButton = false;
uint8_t counter=0;
int answerCounter = 0;
int readTimeStart=0;
//Буфферы
string timeBuffer;
uint8_t request[50] = "Hello!I am SIM800,I send you message from stm32";
uint8_t *receiveMsg[50];
char answer[300];
char sslBuffer[1402];
 char  * encoded;
 string id_Stm;
//Прерывания
InterruptIn button(BUTTON1);
InterruptIn sd_button(D5);
//Настройка пинов
DigitalOut myLed(LED1);
DigitalOut RedLed(LED3);
DigitalIn   myButton(D5);
Serial sim800(GSMRX,GSMTX);                                   //Serial communication of the sim800 and pc.
Serial pc(SERIAL_TX,SERIAL_RX);
//Инициализации SD карты 
SDBlockDevice sd(D11, D12, D13, D4);
FATFileSystem fs("sd");
Base64 n;

void encodeBase64()
{
    pc.printf("Read uid !\r\n");
    volatile uint32_t *UniqueID = (uint32_t *)0x1FFF7A10;
    volatile uint32_t __UniqueID[2];
    __UniqueID[0] = UniqueID[0];
    __UniqueID[1] = UniqueID[1];
    __UniqueID[2] = UniqueID[2];
    size_t  encodedLen;
 char  * encoded = n. Encode ((char*)UniqueID,12 ,&encodedLen);
    pc.printf("STMuid:{%s} \ r \ n" ,encoded);
}
//Настройка времени
void simTime()
{   
    sim800.printf("AT\r\n");
    wait(1);
    sim800.printf("AT+CLTS=1\r\n");
    wait(1);
    sim800.printf("AT+CNTPCID=1\r\n");
    wait(1);
    sim800.printf("AT+CNTP=ntp1.vniiftri.ru,7\r\n");
    wait(1);
    sim800.printf("AT+CNTP\r\n");
    wait(1);
    sim800.printf("AT+CCLK?\r\n");
    wait(1); 
    sim800.printf("AT&W\r\n");
    wait(1); 
}
//Отправка команд в модуль СИМ800
void sendAt(const char *AT)
{
  sim800.printf("%s\r\n",AT);
  wait(1);
}
//Отправка сообщения с дисплея 
void lcdStartWork() {    
    message_t *message = mpool.alloc();
    message->lcdData = request; 
    queue.put(message);      
}
//Запись сертификата с SD карты 
void sdReadSsl()
{
    
    pc.printf("Read uid !\r\n");
 
    RedLed = 0;
    volatile uint32_t *UniqueID = (uint32_t *)0x1FFF7A10;
    volatile uint32_t __UniqueID[2];
    __UniqueID[0] = UniqueID[0];
    __UniqueID[1] = UniqueID[1];
    __UniqueID[2] = UniqueID[2];
    size_t  encodedLen;
    char  * encoded = n. Encode ((char*)UniqueID,12 ,&encodedLen);
    pc.printf("STMuid:{%s} \ r \ n" ,encoded);
    id_Stm = encoded;
    sd.init();
    fs.mount(&sd);
    FILE *fp = fopen((string("/sd/")+ encoded +string(".txt")).c_str(), "r");   
    if (fp == NULL) {
        printf("Fail open txt file\r\n");
           myLed = 1;
    }
    fread(sslBuffer, sizeof(sslBuffer), 1, fp );
    fclose(fp);
    printf("File successfully read!\r\n");
    printf(" Your data:\n%s\n",sslBuffer);
    fs.unmount();
    sd.deinit();
    
}

//Отправка сообщения на сервер через модуль 
void gsmStartWork() {
    while(1)
    {
        osEvent evt = queue.get();
        if (evt.status == osEventMessage) 
        {
            message_t *message = (message_t*)evt.value.p;
            *receiveMsg = (uint8_t*)message->lcdData; 
            printf("lcdData: %s\n\r"   , *receiveMsg);   
       if(timeCounter == 0)
        {
            timeCounter = 1;
          //  simTime();
        }
        
        sendAt("AT\r\n");
        sim800.printf("AT+FSDEL=C:\\USER\\SSL2.CRT\n\r");
        wait(0.5);
        sim800.printf("AT+FSCREATE=C:\\USER\\SSL2.CRT\n\r");
        wait(1.5);
        sim800.printf("AT+FSWRITE=C:\\USER\\SSL2.CRT,0,1402,10\n\r");
        wait(0.2);
        sim800.printf("%s\n\r",sslBuffer);
        wait(1);
        sim800.printf("AT+SSLSETCERT=C:\\USER\\SSL2.CRT\n\r");
        wait(3);
        answerCounter=1;
        sendAt("AT+CCLK?\r\n");
        wait(1.5);
        answerCounter=0;
        sendAt("AT+SAPBR=3,1,Contype,GPRS\r\n");     
        sendAt("AT+SAPBR=3,1,APN,internet.mts.ru\r\n");
        sendAt("AT+SAPBR=3,1,USER,mts\r\n");
        sendAt("AT+SAPBR=3,1,PWD,mts");
        sendAt("AT+SAPBR=1,1");
        sendAt("AT+HTTPINIT");
        sendAt("AT+HTTPSSL=1");
        sendAt("AT+HTTPPARA=URL,157.230.245.76:1880/message");
        pc.printf("%s\r\n",id_Stm);
        sim800.printf("AT+HTTPPARA=UA,%s-1.0.0\r\n",id_Stm);
        wait(0.5);
        sendAt("AT+HTTPPARA=CONTENT,application/octet-stream");
        sendAt("AT+HTTPDATA=51,10000");
        sim800.write(*receiveMsg,51,NULL,SERIAL_EVENT_TX_COMPLETE);
        wait(0.5);
        sendAt("AT+HTTPACTION=1");
        wait(1.5);
        sendAt("AT+HTTPTERM");
        wait(1.5);
        sendAt("AT+HTTPTERM");
        wait(1.5);
        sendAt("AT+SAPBR=0,1");
        pc.printf("Time: %s\n\r",timeBuffer);   
        mpool.free(message);  
            }
        }
}

//Запись логов 
void sdWriteLog()
{
    sd.init();
    fs.mount(&sd);
    printf(" Log write start!\n\n");
    FILE *fp2 = fopen("/sd/log.txt", "a+");
    fprintf(fp2, "Hello World!%s\r\n",timeBuffer);
    fclose(fp2);
    printf(" Log write DONE!\n\n");
    fs.unmount();
    sd.deinit();
}
//Прерывание на нажатие кнопки
void buttonPressed()
{   
   // sdEvent.call(&sdReadSsl);
    counter++;
    evq.call(&lcdStartWork);
    pressedButton=true;
    //sdReadSsl();
}
void sslButtonPressed()
{   
    if(pressedButton==false)   sdEvent.call(&sdReadSsl);
    pressedButton==false;
    //sdReadSsl();
}
//Прерывание на отжим кнопки
void buttonReleased()
{
    
    pressedButton=false; 
}
void sslButtonReleased()
{
    
    pressedButton=true; 
}
//Задача для записи логов
void sdWork()
{
    while(1)
    {
        sdEvent.call(&sdWriteLog);
        wait(15);
    }
}
//MAIN-----------------------------------------------    
int main()
{
    pc.baud(9600);
    sim800.baud(9600);
    
    pc.printf("*******GPRS TEST*******\r\n");
    
    myButton.mode(PullUp);
    button.rise(&buttonReleased);
    button.fall(&buttonPressed);
    sd_button.rise(&sslButtonReleased);
    sd_button.fall(&sslButtonPressed);
    
    
    gsmTask.start(gsmStartWork);
    //sdLogWrite.start(sdWork);
    
    eventThread.start(callback(&evq, &EventQueue::dispatch_forever));
    sdEventThread.start(callback(&sdEvent,&EventQueue::dispatch_forever));
    while(1) {
        if(answerCounter==0)
        {
            if(pc.readable()) { 
            sim800.putc(pc.getc()); 
            } 
            if(sim800.readable()) { 
            pc.putc(sim800.getc()); 
            } 
        }
        else
        {
             if(sim800.readable()) 
             { 
                 if(readTimeStart == 1)
                 {
                     if(readTimeStart == 1) timeBuffer += char(c);
                     if(char(c) =='+') readTimeStart = 0;
                 }
                            if(char(c) =='"') readTimeStart = 1;
                            c = sim800.getc(); 
            } 
        }
    }
}