#include "mbed.h"
 
#define MAX_QUEUE 512          // Indexed from 0 to 511
 
AnalogOut speaker(PA_4);        // DAC for the speaker/output
AnalogIn  mic(A2);            // ADC for the microphone/input
//AnalogIn  pot(p20);            // ADC for the pot

int main()
{
    int queue[MAX_QUEUE];      // Will be a circular buffer

    int ii = 0;                // Queue write position
    int jj = 0;                // Q read position
    int offset = 0;            // Delay (number of samples)
    int oo;                    // The analogue data read or written
    
    while(1)                   // For ever
    {
        oo = mic.read_u16() - 32767;    // Read ADC and remove DC offset
      
        queue[ii] = oo;                 // Add sample to queue
        
        jj = ii - offset;               // Calculate playback position
        
        if (jj < 0) jj = jj + MAX_QUEUE;// If queue pointer is negative, wrap it around.
        
        ii = (ii + 1) % MAX_QUEUE;      // Next position in the circular queue
        
        if (ii == 0)                    // Read the potentiometer
        {
            offset = MAX_QUEUE * 32767 / 65535;  // Scale the reading to fit the queue
            
            if (offset >= MAX_QUEUE) offset = MAX_QUEUE - 1;  // Limit the upper value
        }

        oo = oo + queue[jj];            // Add zero referenced signals: input + delayed_input

        oo = oo + 32767;                // Restore the DC Offset.
        
        speaker.write_u16(oo);          // DAC output
        //printf();
        
        if (!(ii % 16)) printf("oo = %5d | ii = %5d | jj = %5d | offset = %5d \n\r", oo, ii, jj, offset);
        // FOR DEBUGGING if (!(ii % 16)) printf("oo = %5d | ii = %5d | jj = %5d | offset = %5d \n\r", oo, ii, jj, offset);
    }
}