#include "mbed.h"
#include "tag_math.h"
#include "stm32f4xx_hal.h"
#include "bluenrg_shield_bsp.h"
#include "osal.h"
#include "sample_service.h"
#include <stdio.h>

#define BDADDR_SIZE 6

/* SPI handler declaration */
SPI_HandleTypeDef SpiHandle;

Serial pc(SERIAL_TX, SERIAL_RX);
PwmOut mypwm(D2);
AnalogIn analog_value(A2);
int flag = 0;

extern volatile uint8_t set_connectable;
extern volatile int connected;
extern volatile uint8_t notification_enabled;

void User_Process(void);


/******************************************************************************/
/******************************************************************************/
int main(void)
{
    tHalUint8 CLIENT_BDADDR[] = {0xbb, 0x00, 0x00, 0xE1, 0x80, 0x02};
    
    tHalUint8 bdaddr[BDADDR_SIZE];
    
    uint16_t service_handle, dev_name_char_handle, appearance_char_handle;
    int ret;
    
    /* Hardware init*/
    HAL_Init();
    
    /* Configure the system clock */
    SystemClock_Config();
    
    mypwm.period_ms(20);
    //mypwm.pulsewidth_ms(1.5);
    
    /* Initialize the BlueNRG SPI driver */
    BNRG_SPI_Init();
    
    
    /* Initialize the BlueNRG HCI */
    HCI_Init();
    
    /* Reset BlueNRG hardware */
    BlueNRG_RST();
       
    Osal_MemCpy(bdaddr, CLIENT_BDADDR, sizeof(CLIENT_BDADDR));       
    
    ret = aci_hal_write_config_data(CONFIG_DATA_PUBADDR_OFFSET,
                                    CONFIG_DATA_PUBADDR_LEN,
                                    bdaddr);
    if(ret){
        pc.printf("Setting BD_ADDR failed.\n");
    }
    
    ret = aci_gatt_init();    
    if(ret){
        pc.printf("GATT_Init failed.\n");
    }    

    ret = aci_gap_init(GAP_CENTRAL_ROLE, &service_handle, &dev_name_char_handle, &appearance_char_handle);

    if(ret != BLE_STATUS_SUCCESS){
        pc.printf("GAP_Init failed.\n");
    }
    
    ret = aci_gap_set_auth_requirement(MITM_PROTECTION_REQUIRED,
                                       OOB_AUTH_DATA_ABSENT,
                                       NULL,
                                       7,
                                       16,
                                       USE_FIXED_PIN_FOR_PAIRING,
                                       123456,
                                       BONDING);
                                       
                                       
    if (ret != BLE_STATUS_SUCCESS) {
        pc.printf("BLE Stack Initialization failed.\n");
    }
    
    /* Set output power level */
    ret = aci_hal_set_tx_power_level(1,4);
    
    static uint32_t cnt1=0;
    
    /* Infinite loop */
    while (1)
    {
        /*
        for(float offset=0.0; offset<0.001; offset+=0.0001) {
            mypwm.pulsewidth(0.001 + offset); // servo position determined by a pulsewidth between 1-2ms
            wait(0.25);
        }
        */
        
        if (HAL_GetTick() > (cnt1 + 1000))
        {
            cnt1=HAL_GetTick();
            if (flag==0){
                mypwm.period_ms(20);
                mypwm.pulsewidth_ms(0.9);
                flag++;
                }
            else if (flag==1){
                mypwm.period_ms(20);
                mypwm.pulsewidth_ms(1.5);
                flag++;
                }
            else if (flag==2){
                mypwm.period_ms(20);
                mypwm.pulsewidth_ms(2.0);
                flag=0;
                }
        }
        HCI_Process();
        User_Process();
    }
    
}

/******************************************************************************/
/******************************************************************************/

void User_Process(void)
{
    static uint32_t cnt;
    static uint8_t acc_en_sent = 0; 
    tHalUint8 data[2];
    uint8_t* temp;
    //uint8_t data_length;
        
    if(set_connectable){
        Make_Connection();
        set_connectable = FALSE;
    }
    
    /*if(connected && !notification_enabled) {
        enableNotification();
    }*/
    
    if((connected)&&(!acc_en_sent)){
        
        HAL_Delay(100);
        data[0] = 0x01;
        sendData(0x0029, data, 1); 
        
        HAL_Delay(100);
        data[0] = 0x01;
        sendData(0x0031, data, 1); 
  
        HAL_Delay(100);
        data[0] = 0x01;
        sendData(0x003C, data, 1); 
        
        HAL_Delay(100);
        data[0] = 0x10;
        sendData(0x0034, data, 1);
        
        
        acc_en_sent = 1;
        cnt = HAL_GetTick();    
    } 
    
    if (HAL_GetTick() > (cnt +2000))
    {
        cnt = HAL_GetTick();
        if (connected && acc_en_sent)
        {
                               
            
            float sheint = analog_value.read();
            pc.printf("Light = %f;\n", sheint);
            pc.printf("T = %f; ", calcTmpTarget(readValue(0x25, NULL)));
            temp = readValue(0x2D, NULL);
            pc.printf("Ax = %d; Ay = %d; Az = %d  ", (signed char) temp[0], (signed char) temp[1], (signed char) temp[2]);
            temp = readValue(0x38, NULL);
            pc.printf("H = %f; \r\n", calcHumRel(temp));
            
            
            /*temp = readValue(0x2D, NULL);
            pc.printf("%d %d \r\n", (signed char) temp[0], (signed char) temp[1]);*/
            
            /*pc.printf("%d ", (signed short)calcTmpTarget(readValue(0x25, NULL)));
            temp = readValue(0x38, NULL);
            pc.printf("%d \r\n", (signed short)calcHumRel(temp));*/
            
            //GATT services scan
            /*for (unsigned char j = 1; j < 0x88; j++)
            {
                pc.printf("\n %.2X: ", j);
                uint8_t* temp = readValue(j+1, &data_length);
                
                
                for(int i = 0; i < data_length; i++) {
                    pc.printf("%.2X:",  temp[i]);
                }

                for(int i = 0; i < data_length; i++) {
                    pc.printf("%c",  temp[i]);
                }

            }
            */
            
        }
    }
    
}
/******************************************************************************/
/******************************************************************************/

/*********************** END OF FILE ******************************************/
