#ifndef _SAMPLE_SERVICE_H_
#define _SAMPLE_SERVICE_H_

#ifdef __cplusplus
 extern "C" {
#endif

#include "cube_hal.h"
#include "hal_types.h"
#include "gatt_server.h"
#include "gap.h"
#include "string.h"
#include "bluenrg_hci.h"
#include "hci_internal.h"
#include "gp_timer.h"
#include "bluenrg_hci_internal.h"
#include "hci.h"
#include "hal.h"
#include "sm.h"

#define TX_HANDLE 0x0011

#define RX_HANDLE   0x0014

#define READ_TIMEOUT 100000

void Make_Connection(void);
void receiveData(uint8_t* data_buffer, uint8_t Nb_bytes);
void sendData(uint16_t handle, uint8_t* data_buffer, uint8_t Nb_bytes);
void enableNotification(void);
void GAP_ConnectionComplete_CB(uint8_t addr[6], uint16_t handle);
void GAP_DisconnectionComplete_CB(void);
void GATT_Notification_CB(uint16_t attr_handle, uint8_t attr_len, uint8_t *attr_value);
void GATT_Read_CB(uint16_t attr_handle, uint8_t attr_len, uint8_t *attr_value);
void HCI_Event_CB(void *pckt);
uint8_t *readValue(unsigned short handle, uint8_t* len);
void moveMouse(int8_t x, int8_t y);

#ifdef __cplusplus
}
#endif

#endif /* _SAMPLE_SERVICE_H_ */
