#include "mbed.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "wave_player.h"

//The section below lists all inputs and outputs for the program. 
//pc allows us to read data on the PC should we need to check that correct values are going through.
//LCD allows us to connect to the uLCD display and send commands as needed.
//sd allows us to send commands to the SD card reader on the board.
//DACout is connected to the speaker and outputs audio gathered from the SD Card reader.
//Sonr allows for the MBED to read in data from the EZ-LV Sonar.
//waver allows us to connect to DACout and play audio files as needed.

Serial pc(USBTX,USBRX);       
uLCD_4DGL LCD(p9,p10,p11);
SDFileSystem sd(p5, p6, p7, p12, "sd"); //SD card
AnalogOut DACout(p18);
AnalogIn Sonr(p17);
wave_player waver(&DACout);

FILE *wave_file;
int trigger=4;
int Cat=0;
float adc, volts, inches;
int feet, in;


int main() {
    
while(1){
     
        pc.printf("%8.2fV %8.2f in\n", volts, inches);     //If the Sonar needs to be checked for functionality
        adc = Sonr.read();           // read analog as a float
        volts = adc * 3.3;          // convert to volts
        inches = volts / 0.0064;    // 3.3V supply: 6.4mV per inch
    
    
    //The first condition is that if the Sonar detects an object less than 8 inches above, then the AngryCat.wav file will play
    //through the speaker and the LCD display will access from its SD card the AngryCat.jpg file.
    
    
     if(inches < 8){  
            
          //The below if statement runs only if the entire preceding if statement has run at least once. It ensures that when 
          //the program runs, it only clears the screen when an image transition occurs.  
            
         if(trigger != 0){
             LCD.cls();           
           }
           
    LCD.media_init();
    LCD.set_sector_address(0x000F, 0x2301);
    LCD.display_image(0,0);
    wave_file=fopen("/sd/AngryCat.wav","r");
    waver.play(wave_file);
    fclose(wave_file);
    trigger=0;
    }
    
  //The second condition is that if the Sonar detects an object between 8 inches to 12 inches above the Sonar, then the NervousCat.wav file will play
  //through the speaker and the LCD will display from its SD card the NervousCat.jpg file.
 
    
    else if(inches >= 8 && inches < 12){  
    
      if(trigger != 1){
        LCD.cls();               
           }
           
    LCD.media_init();
    LCD.set_sector_address(0x000F, 0x2342);
    LCD.display_image(0,0);
    wave_file=fopen("/sd/NervousCat.wav","r");
    waver.play(wave_file);
    fclose(wave_file);
    trigger=1;
    }
    
    
  //The last condition is that if the Sonar detects an object further than 12 inches above the Sonar, then the NiceCat.wav file will play
  //through the speaker and the LCD will display from its SD card the NiceCat.jpg file.
   
    
    else if(inches > 12){
        
          if(trigger != 2){
          LCD.cls();          
           }  
           
    LCD.media_init();
    LCD.set_sector_address(0x000F, 0x2383);
    LCD.display_image(0,0);
    wave_file=fopen("/sd/NiceCat.wav","r");
    waver.play(wave_file);
    fclose(wave_file);
    trigger=2;
    }
    }
}
