/*
* N3310LCD. A program to interface mbed with the nuelectronics
* Nokia 3310 LCD shield from www.nuelectronics.com. Ported from
* the nuelectronics Arduino code.
*
* Copyright (C) <2009> Petras Saduikis <petras@petras.co.uk>
*
* Converted to a mbed library by Andrew D. Lindsay
*
* This file is part of N3310LCD.
*
* N3310LCD is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* N3310LCD is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with N3310LCD.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef N3310FONTS_H
#define N3310FONTS_H

// 6 x 8 font
// 1 pixel space at left and bottom
// index = ASCII - 32

unsigned char font6_8[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ,   // sp
    0x00, 0x00, 0x00, 0x2f, 0x00, 0x00 ,   // !
    0x00, 0x00, 0x07, 0x00, 0x07, 0x00 ,   // "
    0x00, 0x14, 0x7f, 0x14, 0x7f, 0x14 ,   // #
    0x00, 0x24, 0x2a, 0x7f, 0x2a, 0x12 ,   // $
    0x00, 0x62, 0x64, 0x08, 0x13, 0x23 ,   // %
    0x00, 0x36, 0x49, 0x55, 0x22, 0x50 ,   // &
    0x00, 0x00, 0x05, 0x03, 0x00, 0x00 ,   // '
    0x00, 0x00, 0x1c, 0x22, 0x41, 0x00 ,   // (
    0x00, 0x00, 0x41, 0x22, 0x1c, 0x00 ,   // )
    0x00, 0x14, 0x08, 0x3E, 0x08, 0x14 ,   // *
    0x00, 0x08, 0x08, 0x3E, 0x08, 0x08 ,   // +
    0x00, 0x00, 0x00, 0xA0, 0x60, 0x00 ,   // ,
    0x00, 0x08, 0x08, 0x08, 0x08, 0x08 ,   // -
    0x00, 0x00, 0x60, 0x60, 0x00, 0x00 ,   // .
    0x00, 0x20, 0x10, 0x08, 0x04, 0x02 ,   // /
    0x00, 0x3E, 0x51, 0x49, 0x45, 0x3E ,   // 0
    0x00, 0x00, 0x42, 0x7F, 0x40, 0x00 ,   // 1
    0x00, 0x42, 0x61, 0x51, 0x49, 0x46 ,   // 2
    0x00, 0x21, 0x41, 0x45, 0x4B, 0x31 ,   // 3
    0x00, 0x18, 0x14, 0x12, 0x7F, 0x10 ,   // 4
    0x00, 0x27, 0x45, 0x45, 0x45, 0x39 ,   // 5
    0x00, 0x3C, 0x4A, 0x49, 0x49, 0x30 ,   // 6
    0x00, 0x01, 0x71, 0x09, 0x05, 0x03 ,   // 7
    0x00, 0x36, 0x49, 0x49, 0x49, 0x36 ,   // 8
    0x00, 0x06, 0x49, 0x49, 0x29, 0x1E ,   // 9
    0x00, 0x00, 0x36, 0x36, 0x00, 0x00 ,   // :
    0x00, 0x00, 0x56, 0x36, 0x00, 0x00 ,   // ;
    0x00, 0x08, 0x14, 0x22, 0x41, 0x00 ,   // <
    0x00, 0x14, 0x14, 0x14, 0x14, 0x14 ,   // =
    0x00, 0x00, 0x41, 0x22, 0x14, 0x08 ,   // >
    0x00, 0x02, 0x01, 0x51, 0x09, 0x06 ,   // ?
    0x00, 0x32, 0x49, 0x59, 0x51, 0x3E ,   // @
    0x00, 0x7C, 0x12, 0x11, 0x12, 0x7C ,   // A
    0x00, 0x7F, 0x49, 0x49, 0x49, 0x36 ,   // B
    0x00, 0x3E, 0x41, 0x41, 0x41, 0x22 ,   // C
    0x00, 0x7F, 0x41, 0x41, 0x22, 0x1C ,   // D
    0x00, 0x7F, 0x49, 0x49, 0x49, 0x41 ,   // E
    0x00, 0x7F, 0x09, 0x09, 0x09, 0x01 ,   // F
    0x00, 0x3E, 0x41, 0x49, 0x49, 0x7A ,   // G
    0x00, 0x7F, 0x08, 0x08, 0x08, 0x7F ,   // H
    0x00, 0x00, 0x41, 0x7F, 0x41, 0x00 ,   // I
    0x00, 0x20, 0x40, 0x41, 0x3F, 0x01 ,   // J
    0x00, 0x7F, 0x08, 0x14, 0x22, 0x41 ,   // K
    0x00, 0x7F, 0x40, 0x40, 0x40, 0x40 ,   // L
    0x00, 0x7F, 0x02, 0x0C, 0x02, 0x7F ,   // M
    0x00, 0x7F, 0x04, 0x08, 0x10, 0x7F ,   // N
    0x00, 0x3E, 0x41, 0x41, 0x41, 0x3E ,   // O
    0x00, 0x7F, 0x09, 0x09, 0x09, 0x06 ,   // P
    0x00, 0x3E, 0x41, 0x51, 0x21, 0x5E ,   // Q
    0x00, 0x7F, 0x09, 0x19, 0x29, 0x46 ,   // R
    0x00, 0x46, 0x49, 0x49, 0x49, 0x31 ,   // S
    0x00, 0x01, 0x01, 0x7F, 0x01, 0x01 ,   // T
    0x00, 0x3F, 0x40, 0x40, 0x40, 0x3F ,   // U
    0x00, 0x1F, 0x20, 0x40, 0x20, 0x1F ,   // V
    0x00, 0x3F, 0x40, 0x38, 0x40, 0x3F ,   // W
    0x00, 0x63, 0x14, 0x08, 0x14, 0x63 ,   // X
    0x00, 0x07, 0x08, 0x70, 0x08, 0x07 ,   // Y
    0x00, 0x61, 0x51, 0x49, 0x45, 0x43 ,   // Z
    0x00, 0x00, 0x7F, 0x41, 0x41, 0x00 ,   // [
    0x00, 0x55, 0x2A, 0x55, 0x2A, 0x55 ,   // Checker pattern
    0x00, 0x00, 0x41, 0x41, 0x7F, 0x00 ,   // ]
    0x00, 0x04, 0x02, 0x01, 0x02, 0x04 ,   // ^
    0x00, 0x40, 0x40, 0x40, 0x40, 0x40 ,   // _
    0x00, 0x00, 0x01, 0x02, 0x04, 0x00 ,   // '
    0x00, 0x20, 0x54, 0x54, 0x54, 0x78 ,   // a
    0x00, 0x7F, 0x48, 0x44, 0x44, 0x38 ,   // b
    0x00, 0x38, 0x44, 0x44, 0x44, 0x20 ,   // c
    0x00, 0x38, 0x44, 0x44, 0x48, 0x7F ,   // d
    0x00, 0x38, 0x54, 0x54, 0x54, 0x18 ,   // e
    0x00, 0x08, 0x7E, 0x09, 0x01, 0x02 ,   // f
    0x00, 0x18, 0xA4, 0xA4, 0xA4, 0x7C ,   // g
    0x00, 0x7F, 0x08, 0x04, 0x04, 0x78 ,   // h
    0x00, 0x00, 0x44, 0x7D, 0x40, 0x00 ,   // i
    0x00, 0x40, 0x80, 0x84, 0x7D, 0x00 ,   // j
    0x00, 0x7F, 0x10, 0x28, 0x44, 0x00 ,   // k
    0x00, 0x00, 0x41, 0x7F, 0x40, 0x00 ,   // l
    0x00, 0x7C, 0x04, 0x18, 0x04, 0x78 ,   // m
    0x00, 0x7C, 0x08, 0x04, 0x04, 0x78 ,   // n
    0x00, 0x38, 0x44, 0x44, 0x44, 0x38 ,   // o
    0x00, 0xFC, 0x24, 0x24, 0x24, 0x18 ,   // p
    0x00, 0x18, 0x24, 0x24, 0x18, 0xFC ,   // q
    0x00, 0x7C, 0x08, 0x04, 0x04, 0x08 ,   // r
    0x00, 0x48, 0x54, 0x54, 0x54, 0x20 ,   // s
    0x00, 0x04, 0x3F, 0x44, 0x40, 0x20 ,   // t
    0x00, 0x3C, 0x40, 0x40, 0x20, 0x7C ,   // u
    0x00, 0x1C, 0x20, 0x40, 0x20, 0x1C ,   // v
    0x00, 0x3C, 0x40, 0x30, 0x40, 0x3C ,   // w
    0x00, 0x44, 0x28, 0x10, 0x28, 0x44 ,   // x
    0x00, 0x1C, 0xA0, 0xA0, 0xA0, 0x7C ,   // y
    0x00, 0x44, 0x64, 0x54, 0x4C, 0x44 ,   // z
    0x00,0x00, 0x06, 0x09, 0x09, 0x06     // horiz lines
};

// Font definition for LCD 3110 library
// 5 x 7 font
// 1 pixel space at left and bottom
// index = ASCII - 32

//***** Small fonts (5x7) **********

// This does not strictly follow ASCII table
//
unsigned char font5_7[] = {
    0x00, 0x00, 0x00, 0x00, 0x00 ,   // sp
    0x00, 0x00, 0x2f, 0x00, 0x00 ,   // !
    0x00, 0x07, 0x00, 0x07, 0x00 ,   // "
    0x14, 0x7f, 0x14, 0x7f, 0x14 ,   // #
    0x24, 0x2a, 0x7f, 0x2a, 0x12 ,   // $
    0x61, 0x66, 0x08, 0x33, 0x43 ,   // %
    0x36, 0x49, 0x55, 0x22, 0x50 ,   // &
    0x00, 0x05, 0x03, 0x00, 0x00 ,   // '
    0x00, 0x1c, 0x22, 0x41, 0x00 ,   // (
    0x00, 0x41, 0x22, 0x1c, 0x00 ,   // )
    0x14, 0x08, 0x3E, 0x08, 0x14 ,   // *
    0x08, 0x08, 0x3E, 0x08, 0x08 ,   // +
    0x00, 0x00, 0x50, 0x30, 0x00 ,   // ,
    0x10, 0x10, 0x10, 0x10, 0x10 ,   // -
    0x00, 0x60, 0x60, 0x00, 0x00 ,   // .
    0x20, 0x10, 0x08, 0x04, 0x02 ,   // /
    0x3E, 0x51, 0x49, 0x45, 0x3E ,   // 0
    0x00, 0x42, 0x7F, 0x40, 0x00 ,   // 1
    0x42, 0x61, 0x51, 0x49, 0x46 ,   // 2
    0x21, 0x41, 0x45, 0x4B, 0x31 ,   // 3
    0x18, 0x14, 0x12, 0x7F, 0x10 ,   // 4
    0x27, 0x45, 0x45, 0x45, 0x39 ,   // 5
    0x3C, 0x4A, 0x49, 0x49, 0x30 ,   // 6
    0x01, 0x71, 0x09, 0x05, 0x03 ,   // 7
    0x36, 0x49, 0x49, 0x49, 0x36 ,   // 8
    0x06, 0x49, 0x49, 0x29, 0x1E ,   // 9
    0x00, 0x36, 0x36, 0x00, 0x00 ,   // :
    0x00, 0x56, 0x36, 0x00, 0x00 ,   // ;
    0x08, 0x14, 0x22, 0x41, 0x00 ,   // <
    0x14, 0x14, 0x14, 0x14, 0x14 ,   // =
    0x00, 0x41, 0x22, 0x14, 0x08 ,   // >
    0x02, 0x01, 0x51, 0x09, 0x06 ,   // ?
    0x32, 0x49, 0x59, 0x51, 0x3E ,   // @
    0x7E, 0x11, 0x11, 0x11, 0x7E ,   // A
    0x7F, 0x49, 0x49, 0x49, 0x36 ,   // B
    0x3E, 0x41, 0x41, 0x41, 0x22 ,   // C
    0x7F, 0x41, 0x41, 0x22, 0x1C ,   // D
    0x7F, 0x49, 0x49, 0x49, 0x41 ,   // E
    0x7F, 0x09, 0x09, 0x09, 0x01 ,   // F
    0x3E, 0x41, 0x49, 0x49, 0x7A ,   // G
    0x7F, 0x08, 0x08, 0x08, 0x7F ,   // H
    0x00, 0x41, 0x7F, 0x41, 0x00 ,   // I
    0x20, 0x40, 0x41, 0x3F, 0x01 ,   // J
    0x7F, 0x08, 0x14, 0x22, 0x41 ,   // K
    0x7F, 0x40, 0x40, 0x40, 0x40 ,   // L
    0x7F, 0x02, 0x0C, 0x02, 0x7F ,   // M
    0x7F, 0x04, 0x08, 0x10, 0x7F ,   // N
    0x3E, 0x41, 0x41, 0x41, 0x3E ,   // O
    0x7F, 0x09, 0x09, 0x09, 0x06 ,   // P
    0x3E, 0x41, 0x51, 0x21, 0x5E ,   // Q
    0x7F, 0x09, 0x19, 0x29, 0x46 ,   // R
    0x46, 0x49, 0x49, 0x49, 0x31 ,   // S
    0x01, 0x01, 0x7F, 0x01, 0x01 ,   // T
    0x3F, 0x40, 0x40, 0x40, 0x3F ,   // U
    0x1F, 0x20, 0x40, 0x20, 0x1F ,   // V
    0x3F, 0x40, 0x38, 0x40, 0x3F ,   // W
    0x63, 0x14, 0x08, 0x14, 0x63 ,   // X
    0x07, 0x08, 0x70, 0x08, 0x07 ,   // Y
    0x61, 0x51, 0x49, 0x45, 0x43 ,   // Z
    0x00, 0x7F, 0x41, 0x41, 0x00 ,   // [
    0x55, 0x2A, 0x55, 0x2A, 0x55 ,   // checker pattern
    0x00, 0x41, 0x41, 0x7F, 0x00 ,   // ]
    0x04, 0x02, 0x01, 0x02, 0x04 ,   // ^
    0x40, 0x40, 0x40, 0x40, 0x40 ,   // _
    0x00, 0x01, 0x02, 0x04, 0x00 ,   // '
    0x20, 0x54, 0x54, 0x54, 0x78 ,   // a
    0x7F, 0x48, 0x44, 0x44, 0x38 ,   // b
    0x38, 0x44, 0x44, 0x44, 0x20 ,   // c
    0x38, 0x44, 0x44, 0x48, 0x7F ,   // d
    0x38, 0x54, 0x54, 0x54, 0x18 ,   // e
    0x08, 0x7E, 0x09, 0x01, 0x02 ,   // f
    0x0C, 0x52, 0x52, 0x52, 0x3E ,   // g
    0x7F, 0x08, 0x04, 0x04, 0x78 ,   // h
    0x00, 0x44, 0x7D, 0x40, 0x00 ,   // i
    0x20, 0x40, 0x44, 0x3D, 0x00 ,   // j
    0x7F, 0x10, 0x28, 0x44, 0x00 ,   // k
    0x00, 0x41, 0x7F, 0x40, 0x00 ,   // l
    0x7C, 0x04, 0x18, 0x04, 0x78 ,   // m
    0x7C, 0x08, 0x04, 0x04, 0x78 ,   // n
    0x38, 0x44, 0x44, 0x44, 0x38 ,   // o
    0x7C, 0x14, 0x14, 0x14, 0x08 ,   // p
    0x08, 0x14, 0x14, 0x18, 0x7C ,   // q
    0x7C, 0x08, 0x04, 0x04, 0x08 ,   // r
    0x48, 0x54, 0x54, 0x54, 0x20 ,   // s
    0x04, 0x3F, 0x44, 0x40, 0x20 ,   // t
    0x3C, 0x40, 0x40, 0x20, 0x7C ,   // u
    0x1C, 0x20, 0x40, 0x20, 0x1C ,   // v
    0x3C, 0x40, 0x30, 0x40, 0x3C ,   // w
    0x44, 0x28, 0x10, 0x28, 0x44 ,   // x
    0x0C, 0x50, 0x50, 0x50, 0x3C ,   // y
    0x44, 0x64, 0x54, 0x4C, 0x44 ,   // z
    0x00, 0x06, 0x09, 0x09, 0x06     // Degree symbol
};

//******* VERY LARGE FONTS **********
//used here for displaying numbers 0 - 9 and '+', '-', '.', ':', '/'
// built up on a 16 by 24 matrix but chars are only 12 by 24.

unsigned char big_number[15][3][16] = {

    {   {0x00,0x00,0xc0,0xe0,0x70,0x30,0x30,0x30,0x70,0xe0,0xc0,0x00,0x00,0x00,0x00,0x00}, // '0'
        {0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0x00,0x00,0x00,0x00},
        {0x00,0x07,0x1f,0x38,0x70,0x60,0x60,0x60,0x70,0x38,0x1f,0x07,0x00,0x00,0x00,0x00}
    },

    {   {0x00,0x00,0x00,0xc0,0xc0,0xc0,0xf0,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // '1'
        {0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
        {0x00,0x00,0x00,0x60,0x60,0x60,0x7f,0x7f,0x60,0x60,0x60,0x00,0x00,0x00,0x00,0x00}
    },

    {   {0x00,0xe0,0x60,0x70,0x30,0x30,0x30,0x30,0x60,0xe0,0x80,0x00,0x00,0x00,0x00,0x00},  // '2'
        {0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xc0,0xf0,0x3f,0x1f,0x00,0x00,0x00,0x00,0x00},
        {0x00,0x70,0x78,0x7c,0x6e,0x67,0x63,0x61,0x60,0x60,0x60,0x60,0x00,0x00,0x00,0x00}
    },

    {   {0x00,0xe0,0x60,0x70,0x30,0x30,0x30,0x30,0x30,0x60,0xe0,0xc0,0x00,0x00,0x00,0x00},  // '3'
        {0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x18,0x3c,0x7c,0xe7,0xc3,0x00,0x00,0x00,0x00},
        {0x00,0x38,0x30,0x70,0x60,0x60,0x60,0x60,0x70,0x38,0x1f,0x0f,0x00,0x00,0x00,0x00}
    },

    {   {0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xc0,0x60,0xf0,0xf0,0x00,0x00,0x00,0x00,0x00},  // '4'
        {0x00,0xe0,0xf0,0xdc,0xce,0xc7,0xc1,0xc0,0xc0,0xff,0xff,0x00,0x00,0x00,0x00,0x00},
        {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7f,0x7f,0x00,0x00,0x00,0x00,0x00}
    },

    {   {0x00,0x00,0xf0,0xf0,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00},  // '5'
        {0x00,0x00,0x1f,0x1f,0x18,0x18,0x18,0x18,0x30,0xf0,0xc0,0x00,0x00,0x00,0x00,0x00},
        {0x00,0x30,0x70,0x60,0x60,0x60,0x60,0x70,0x38,0x1f,0x0f,0x00,0x00,0x00,0x00,0x00}
    },

    {   {0x00,0x00,0x80,0xc0,0xe0,0x60,0x30,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00},  // '6'
        {0x00,0xfc,0xff,0x33,0x18,0x18,0x18,0x18,0x18,0x30,0xf0,0xc0,0x00,0x00,0x00,0x00},
        {0x00,0x07,0x1f,0x38,0x70,0x60,0x60,0x60,0x60,0x30,0x1f,0x0f,0x00,0x00,0x00,0x00}
    },

    {   {0x00,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0xb0,0xf0,0xf0,0x00,0x00,0x00,0x00,0x00},  // '7'
        {0x00,0x00,0x00,0x00,0xc0,0xf0,0x78,0x1e,0x07,0x01,0x00,0x00,0x00,0x00,0x00,0x00},
        {0x00,0x60,0x78,0x3e,0x0f,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}
    },

    {   {0x00,0x80,0xe0,0x60,0x30,0x30,0x30,0x30,0x30,0x60,0xe0,0xc0,0x00,0x00,0x00,0x00},  // '8'
        {0x00,0x87,0xe7,0x6c,0x18,0x18,0x30,0x30,0x38,0x6c,0xc7,0x83,0x00,0x00,0x00,0x00},
        {0x00,0x0f,0x3f,0x38,0x70,0x60,0x60,0x60,0x60,0x30,0x1f,0x0f,0x00,0x00,0x00,0x00}
    },

    {   {0x00,0x80,0xc0,0x60,0x30,0x30,0x30,0x30,0x70,0xe0,0xc0,0x00,0x00,0x00,0x00,0x00},  // '9'
        {0x00,0x0f,0x3f,0x30,0x60,0x60,0x60,0x60,0x60,0x30,0xff,0xff,0x00,0x00,0x00,0x00},
        {0x00,0x00,0x00,0x60,0x60,0x60,0x60,0x70,0x38,0x1e,0x0f,0x03,0x00,0x00,0x00,0x00}
    },

    {   {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, // '.'
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0x38,0x38,0x38,0,0,0,0,0,0,0,0,0,0,0,0}
    },

    {   {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, // '+'
        {0,0x40,0x40,0x40,0xF8,0x40,0x40,0x40,0,0,0,0,0,0,0},
        {0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0}
    },

    {   {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},     // '-'
        {0,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    },

    {   {0,0xE0,0xE0,0xE0,0,0,0,0,0,0,0,0,0,0,0,0},    // ':'
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0xE,0xE,0xE,0,0,0,0,0,0,0,0,0,0,0,0}
    },

    {   {0,0,0,0xF0,0,0,0,0,0,0,0,0,0,0,0,0},  // '/'
        {0,0,0xF8,0x7,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0xFC,0x3,0,0,0,0,0,0,0,0,0,0,0,0,0}
    }
};

unsigned char Liberation_Sans17x17_Alpha[] = {
    0x0D, 0x00, 0x10, 0x00, 0x00, 0x1E, 0x00, 0xC0, 0x1F, 0x00, 0xF8, 0x0F, 0x00, 0xFF, 0x03, 0x00, 0x1F, 0x03, 0x00, 0x03, 0x03, 0x00, 0x1F, 0x03, 0x00, 0xFF, 0x03, 0x00, 0xF8, 0x0F, 0x00, 0xC0, 0x1F, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Code for char A
    0x0D, 0x00, 0x00, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0x63, 0x18, 0x00, 0x63, 0x18, 0x00, 0x63, 0x18, 0x00, 0x63, 0x18, 0x00, 0x63, 0x18, 0x00, 0xFF, 0x1C, 0x00, 0xFE, 0x1F, 0x00, 0xDE, 0x0F, 0x00, 0x80, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Code for char B
    0x0D, 0x00, 0x00, 0x00, 0xF8, 0x01, 0x00, 0xFC, 0x07, 0x00, 0xFE, 0x0F, 0x00, 0x0F, 0x0E, 0x00, 0x03, 0x18, 0x00, 0x03, 0x18, 0x00, 0x03, 0x18, 0x00, 0x03, 0x18, 0x00, 0x07, 0x1C, 0x00, 0x0E, 0x0E, 0x00, 0x0E, 0x0E, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Code for char C
    0x0D, 0x00, 0x00, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0x03, 0x18, 0x00, 0x03, 0x18, 0x00, 0x03, 0x18, 0x00, 0x03, 0x18, 0x00, 0x07, 0x1C, 0x00, 0x0E, 0x0E, 0x00, 0xFE, 0x0F, 0x00, 0xFC, 0x07, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Code for char D
    0x0C, 0x00, 0x00, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0x63, 0x18, 0x00, 0x63, 0x18, 0x00, 0x63, 0x18, 0x00, 0x63, 0x18, 0x00, 0x63, 0x18, 0x00, 0x63, 0x18, 0x00, 0x63, 0x18, 0x00, 0x03, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Code for char E
    0x0B, 0x00, 0x00, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0x63, 0x00, 0x00, 0x63, 0x00, 0x00, 0x63, 0x00, 0x00, 0x63, 0x00, 0x00, 0x63, 0x00, 0x00, 0x63, 0x00, 0x00, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Code for char F
    0x0E, 0x00, 0x00, 0x00, 0xF0, 0x01, 0x00, 0xFC, 0x07, 0x00, 0xFE, 0x0F, 0x00, 0x0E, 0x0E, 0x00, 0x07, 0x1C, 0x00, 0x03, 0x18, 0x00, 0x03, 0x18, 0x00, 0xC3, 0x18, 0x00, 0xC3, 0x18, 0x00, 0xC7, 0x1C, 0x00, 0xCE, 0x0F, 0x00, 0xCE, 0x0F, 0x00, 0xC4, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Code for char G
    0x0C, 0x00, 0x00, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0x60, 0x00, 0x00, 0x60, 0x00, 0x00, 0x60, 0x00, 0x00, 0x60, 0x00, 0x00, 0x60, 0x00, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Code for char H
    0x04, 0x00, 0x00, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Code for char I
    0x0A, 0x00, 0x06, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x1C, 0x00, 0x03, 0x18, 0x00, 0x03, 0x18, 0x00, 0x03, 0x1C, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x0F, 0x00, 0xFF, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Code for char J
    0x0E, 0x00, 0x00, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0xE0, 0x00, 0x00, 0x60, 0x00, 0x00, 0x70, 0x00, 0x00, 0xF8, 0x01, 0x00, 0xDC, 0x03, 0x00, 0x8E, 0x07, 0x00, 0x07, 0x0E, 0x00, 0x03, 0x1C, 0x00, 0x01, 0x18, 0x00, 0x01, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Code for char K
    0x0B, 0x00, 0x00, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Code for char L
    0x10, 0x00, 0x00, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0x0F, 0x00, 0x00, 0x7E, 0x00, 0x00, 0xF0, 0x03, 0x00, 0x80, 0x1F, 0x00, 0x00, 0x1C, 0x00, 0x80, 0x1F, 0x00, 0xF0, 0x03, 0x00, 0x7E, 0x00, 0x00, 0x0F, 0x00, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0x00, 0x00, 0x00,  // Code for char M
    0x0C, 0x00, 0x00, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0x1F, 0x00, 0x00, 0x7C, 0x00, 0x00, 0xF0, 0x01, 0x00, 0xC0, 0x07, 0x00, 0x00, 0x1E, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Code for char N
    0x0E, 0x00, 0x00, 0x00, 0xF0, 0x01, 0x00, 0xFC, 0x07, 0x00, 0xFE, 0x0F, 0x00, 0x0E, 0x0E, 0x00, 0x07, 0x1C, 0x00, 0x03, 0x18, 0x00, 0x03, 0x18, 0x00, 0x03, 0x18, 0x00, 0x07, 0x1C, 0x00, 0x0E, 0x0E, 0x00, 0xFE, 0x0F, 0x00, 0xFC, 0x07, 0x00, 0xF0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Code for char O
    0x0C, 0x00, 0x00, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0x63, 0x00, 0x00, 0x63, 0x00, 0x00, 0x63, 0x00, 0x00, 0x63, 0x00, 0x00, 0x63, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Code for char P
    0x0E, 0x00, 0x00, 0x00, 0xF0, 0x03, 0x00, 0xFC, 0x07, 0x00, 0xFE, 0x0F, 0x00, 0x0E, 0x1E, 0x00, 0x07, 0x1C, 0x00, 0x03, 0x38, 0x00, 0x03, 0xF8, 0x00, 0x03, 0xF8, 0x01, 0x07, 0xDC, 0x01, 0x0E, 0x9E, 0x01, 0xFE, 0x8F, 0x01, 0xFC, 0x87, 0x01, 0xF0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Code for char Q
    0x0D, 0x00, 0x00, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0x63, 0x00, 0x00, 0x63, 0x00, 0x00, 0x63, 0x00, 0x00, 0xE3, 0x00, 0x00, 0xE3, 0x03, 0x00, 0xBF, 0x0F, 0x00, 0x3E, 0x1F, 0x00, 0x1C, 0x1C, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Code for char R
    0x0C, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x1C, 0x0E, 0x00, 0x3E, 0x0E, 0x00, 0x7F, 0x1C, 0x00, 0x73, 0x18, 0x00, 0x63, 0x18, 0x00, 0xE3, 0x18, 0x00, 0xE7, 0x18, 0x00, 0xCF, 0x1F, 0x00, 0xCE, 0x0F, 0x00, 0x8C, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Code for char S
    0x0C, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0xFF, 0x1F, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Code for char T
    0x0C, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0xFF, 0x0F, 0x00, 0xFF, 0x0F, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x00, 0x1C, 0x00, 0xFF, 0x0F, 0x00, 0xFF, 0x0F, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Code for char U
    0x0D, 0x03, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x7F, 0x00, 0x00, 0xFC, 0x01, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x18, 0x00, 0x00, 0x1F, 0x00, 0xE0, 0x0F, 0x00, 0xF8, 0x01, 0x00, 0x7F, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Code for char V
    0x11, 0x07, 0x00, 0x00, 0x7F, 0x00, 0x00, 0xFF, 0x07, 0x00, 0xF0, 0x1F, 0x00, 0x00, 0x1E, 0x00, 0xC0, 0x1F, 0x00, 0xFC, 0x0F, 0x00, 0xFF, 0x00, 0x00, 0x07, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFC, 0x0F, 0x00, 0xC0, 0x1F, 0x00, 0x00, 0x1E, 0x00, 0xF0, 0x1F, 0x00, 0xFF, 0x07, 0x00, 0x7F, 0x00, 0x00, 0x07, 0x00, 0x00,  // Code for char W
    0x0D, 0x01, 0x10, 0x00, 0x03, 0x18, 0x00, 0x07, 0x1C, 0x00, 0x1E, 0x0F, 0x00, 0xBC, 0x07, 0x00, 0xF0, 0x01, 0x00, 0xE0, 0x00, 0x00, 0xF0, 0x01, 0x00, 0xBC, 0x07, 0x00, 0x1E, 0x0F, 0x00, 0x0F, 0x1E, 0x00, 0x03, 0x18, 0x00, 0x01, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Code for char X
    0x0C, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x07, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x7C, 0x00, 0x00, 0xF0, 0x1F, 0x00, 0xC0, 0x1F, 0x00, 0xF0, 0x1F, 0x00, 0x7C, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x07, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // Code for char Y
    0x0A, 0x00, 0x00, 0x00, 0x03, 0x1C, 0x00, 0x03, 0x1E, 0x00, 0x83, 0x1F, 0x00, 0xC3, 0x1B, 0x00, 0xF3, 0x19, 0x00, 0x7B, 0x18, 0x00, 0x3F, 0x18, 0x00, 0x0F, 0x18, 0x00, 0x07, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   // Code for char Z
};

#endif
