#include "mbed.h"
#include "N3310SPIConfig.h"
#include "N3310LCD.h"
#include "rtos.h"
#include <string>
 
Serial pc(USBTX, USBRX); // tx, rx
PwmOut led1(LED1);
PwmOut led2(LED2);
PwmOut led3(LED3);
PwmOut led4(LED4);

N3310LCD lcd(N3310SPIPort::MOSI, N3310SPIPort::MISO, N3310SPIPort::SCK, N3310SPIPort::CE, N3310SPIPort::DAT_CMD, N3310SPIPort::LCD_RST, N3310SPIPort::BL_ON);
 
double all_bright = 0.0;
double led1_bright = 0.0;
double led2_bright = 0.0;
double led3_bright = 0.0;
double led4_bright = 0.0;
 
int main() {
    lcd.init();
    lcd.cls();
    int main;
    int line;
    int loop;
    
    main = 0;
    line = 0;
    loop = 0;
    
    while(main < 1) {
        lcd.cls();
        lcd.writeString(19, 2, "Welcome!", NORMAL);
        wait(2);
        lcd.cls();
        lcd.writeString(25, 0, "Intro", NORMAL);
        lcd.writeString(2, 2, "Continue = c", NORMAL);
        lcd.writeString(2, 3, "Skip = x", NORMAL);
        char c = pc.getc();
        if(c == 'x') {
            lcd.cls();
            lcd.writeString(10, 2, "Please wait", NORMAL);
            main += 1;
            break;
        }
        else if(c == 'c') {
            lcd.cls();
            lcd.printf(" All   = q    ");
            lcd.printf(" LED 1 = w & a");
            lcd.printf(" LED 2 = e & s");
            lcd.printf(" LED 3 = r & d");
            lcd.printf(" LED 4 = t & f");
            lcd.printf(" All   = y    ");
            wait(5);
            lcd.cls();
            lcd.writeString(10, 2, "Please wait", NORMAL);
            main += 1;
        }
    }
    
    while(loop < 82) {
        wait(0.05);
        lcd.writeString(line, 2, ".", NORMAL);
        line += 1;
        if(line == 82) {
            lcd.cls();
            lcd.writeString(25, 2, "Ready!", NORMAL);
        }
        loop += 1;
    }
    
    while(1){
        char c = pc.getc();
        if((c == 'q') && (all_bright < 0.9)) {
            led1_bright += 1.0;
            led2_bright += 1.0;
            led3_bright += 1.0;
            led4_bright += 1.0;
            all_bright += 1.0;
            led1 = led1_bright;
            led2 = led2_bright;
            led3 = led3_bright;
            led4 = led4_bright;
            lcd.cls();
            lcd.writeString(5, 2, "All LED's On!", NORMAL);
            lcd.writeString(13, 4, "Brightness", NORMAL);
            lcd.printf("\n\n\n\n\n\n\n\n\n%g", all_bright);
        }
        
        if((c == 'y') && (all_bright > 0.0)) {
            led1_bright -= 1.0;
            led2_bright -= 1.0;
            led3_bright -= 1.0;
            led4_bright -= 1.0;
            all_bright -= 1.0;
            led1 = led1_bright;
            led2 = led2_bright;
            led3 = led3_bright;
            led4 = led4_bright;
            if(all_bright < 0.00) {
                all_bright = 0;
            }
            lcd.cls();
            lcd.writeString(2, 2, "All LED's Off!", NORMAL);
            lcd.writeString(13, 4, "Brightness", NORMAL);
            lcd.printf("\n\n\n\n\n\n\n\n\n%g", all_bright);
        } 
         
        if((c == 'w') && (led1_bright < 0.9)) {
            led1_bright += 0.1;
            led1 = led1_bright;
            lcd.cls();
            lcd.writeString(15, 2, "LED 1 Up!", NORMAL);
            lcd.writeString(13, 4, "Brightness", NORMAL);
            lcd.printf("\n\n\n\n\n\n\n\n\n%g", led1_bright);
        }
        
        if((c == 'a') && (led1_bright > 0.0)) {
            led1_bright -= 0.1;
            led1 = led1_bright;
            if(led1_bright < 0.00) {
                led1_bright = 0;
            }
            lcd.cls();
            lcd.writeString(10, 2, "LED 1 Down!", NORMAL);
            lcd.writeString(13, 4, "Brightness", NORMAL);
            lcd.printf("\n\n\n\n\n\n\n\n\n%g", led1_bright);
        }
        
        if((c == 'e') && (led2_bright < 0.9)) {
            led2_bright += 0.1;
            led2 = led2_bright;
            lcd.cls();
            lcd.writeString(15, 2, "LED 2 Up!", NORMAL);
            lcd.writeString(13, 4, "Brightness", NORMAL);
            lcd.printf("\n\n\n\n\n\n\n\n\n%g", led2_bright);
        }
        
        if((c == 's') && (led2_bright > 0.0)) {
            led2_bright -= 0.1;
            led2 = led2_bright;
            if(led2_bright < 0.00) {
                led2_bright = 0;
            }
            lcd.cls();
            lcd.writeString(10, 2, "LED 2 Down!", NORMAL);
            lcd.writeString(13, 4, "Brightness", NORMAL);
            lcd.printf("\n\n\n\n\n\n\n\n\n%g", led2_bright);
        }  
        
        if((c == 'r') && (led3_bright < 0.9)) {
            led3_bright += 0.1;
            led3 = led3_bright;
            lcd.cls();
            lcd.writeString(15, 2, "LED 3 Up!", NORMAL);
            lcd.writeString(13, 4, "Brightness", NORMAL);
            lcd.printf("\n\n\n\n\n\n\n\n\n%g", led3_bright);
        } 
        
        if((c == 'd') && (led3_bright > 0.0)) {
            led3_bright -= 0.1;
            led3 = led3_bright;
            if(led3_bright < 0.00) {
                led3_bright = 0;
            }
            lcd.cls();
            lcd.writeString(10, 2, "LED 3 Down!", NORMAL);
            lcd.writeString(13, 4, "Brightness", NORMAL);
            lcd.printf("\n\n\n\n\n\n\n\n\n%g", led3_bright);
        } 
         
        if((c == 't') && (led4_bright < 0.9)) {
            led4_bright += 0.1;
            led4 = led4_bright;
            lcd.cls();
            lcd.writeString(15, 2, "LED 4 Up!", NORMAL);
            lcd.writeString(13, 4, "Brightness", NORMAL);
            lcd.printf("\n\n\n\n\n\n\n\n\n%g", led4_bright);
        }  
        
        if((c == 'f') && (led4_bright > 0.0)) {
            led4_bright -= 0.1;
            led4 = led4_bright;
            if(led4_bright < 0.00) {
                led4_bright = 0;
            }
            lcd.cls();
            lcd.writeString(10, 2, "LED 4 Down!", NORMAL);
            lcd.writeString(13, 4, "Brightness", NORMAL);
            lcd.printf("\n\n\n\n\n\n\n\n\n%g", led4_bright);
        } 
        
        if(c == 'z') {
            lcd.cls();
            lcd.writeString(25, 2, "System", NORMAL);
            lcd.writeString(23, 3, "Restart", NORMAL);
            all_bright = 1;
            led1 = all_bright;
            led2 = all_bright;
            led3 = all_bright;
            led4 = all_bright;
            wait(2);
            NVIC_SystemReset();
        }
    }
}