#include "Functions.h"
#include "screens.h"
#include "variables.h"
#include "rtos.h"

Ethernet eth;
EthernetInterface eth1;
PwmOut led1(LED1);
PwmOut led2(LED2);
PwmOut led3(LED3);
PwmOut led4(LED4);
char buf[0x600];
int packets;
int loading_loop;
int loading_line;

double version = 1.05;

void Functions::Intro() {
    lcd.init();
    lcd.cls();
    lcd.writeString(19, 2, "Welcome!", NORMAL);
    wait(1);
    lcd.cls();
    lcd.writeString(16, 1, "NetTester", NORMAL);
    lcd.writeString(26, 2, "V", NORMAL);
    lcd.printf("%g", version);
    lcd.writeString(13, 3, "Dan Searle", NORMAL);
    wait(5);
}
      
void Functions::ContrastChange() {
    lcd.cls();
    lcd.printf("Contrast");
    
    lcd.cls();
    lcd.writeString(3, 1,"To change the", NORMAL);
    lcd.writeString(2, 2,"contrast level", NORMAL);
    lcd.writeString(1, 3,"use the up and", NORMAL);
    lcd.writeString(8, 4,"down arrows", NORMAL);
    wait(5);
    
    while(1) {
        lcd.cls();
        lcd.writeString(8, 2,"'c' to skip", NORMAL);
        lcd.printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
        lcd.writeString(7, 4,"Contrast:", NORMAL); 
        lcd.printf("\n%X", contrast);
        char c = pc.getc();
        if(c == 0x41) {
            contrast += 1;
            lcd.init();
        }
        if(c == 0x42) {
            contrast -= 1;
            lcd.init();
        }
        if(c == 'c') {
            break;
        }
        wait(0.1);
    }
}

void Functions::Loading() {
    lcd.cls();
    lcd.writeString(10, 2, "Please wait", NORMAL);
            
    while(loading_loop < 82) {
        wait(0.05);
        lcd.writeString(loading_line, 2, ".", NORMAL);
        loading_line += 1;
        if(loading_line == 82) {
            Packets();
        }
        loading_loop += 1;
    }
}

void Functions::ReadLED() {
    double led1_bright = 0.0;
    double led2_bright = 0.0;
    double led3_bright = 0.0;
    double led4_bright = 0.0;

    led1_bright += 1.0;
    led1 = led1_bright;
    wait(0.1);
    led1_bright -= 1.0;
    led1 = led1_bright;
    led2_bright += 1.0;
    led2 = led2_bright;
    wait(0.1);
    led2_bright -= 1.0;
    led2 = led2_bright;
    led3_bright += 1.0;
    led3 = led3_bright;
    wait(0.1);
    led3_bright -= 1.0;
    led3 = led3_bright;
    led4_bright += 1.0;
    led4 = led4_bright;
    wait(0.1);
    led4_bright -= 1.0;
    led4 = led4_bright;
}

void Functions::FinishLED() {
    double led1_bright = 0.0;
    double led2_bright = 0.0;
    double led3_bright = 0.0;
    double led4_bright = 0.0;

    led1_bright += 1.0;
    led2_bright += 1.0;
    led3_bright += 1.0;
    led4_bright += 1.0;
    led1 = led1_bright;
    led2 = led2_bright;
    led3 = led3_bright;
    led4 = led4_bright;
    wait(2);
    led1_bright -= 1.0;
    led2_bright -= 1.0;
    led3_bright -= 1.0;
    led4_bright -= 1.0;
    led1 = led1_bright;
    led2 = led2_bright;
    led3 = led3_bright;
    led4 = led4_bright;
}

void Functions::Packets() {
    packets = 0;
    
    while(packets < 25) {
        lcd.cls();
        lcd.writeString(21, 2, "Reading", NORMAL);
        lcd.writeString(21, 3, "Packets", NORMAL);
        int size = eth.receive();
        if(size > 0) {
            eth.read(buf, size);
            ReadLED();
            pc.printf("Destination:  %02X:%02X:%02X:%02X:%02X:%02X        ",
                    buf[0], buf[1], buf[2], buf[3], buf[4], buf[5]);
            pc.printf("Source: %02X:%02X:%02X:%02X:%02X:%02X        ",
                    buf[6], buf[7], buf[8], buf[9], buf[10], buf[11]);
            pc.printf("Buffer Remain: %d        ", (sizeof(buf) - size));       
            pc.printf("Received Packet Size: %d\n\r", size);
            
            packets += 1;
        }
        wait(1);
    }
    FinishLED();
}   

void Functions::IPSettings() {
    eth1.init();
    eth1.connect();
    lcd.cls();
    lcd.printf("IP:\n\n\n\n\n\n\n\n\n\n\n");
    lcd.printf("%s", eth1.getIPAddress());
}

void Functions::SystemRestart() {
    double led1_bright = 0.0;
    double led2_bright = 0.0;
    double led3_bright = 0.0;
    double led4_bright = 0.0;

    lcd.writeString(1, 4,"'z' to restart", NORMAL);

    while(1) {
        char c = pc.getc();
        if(c == 'z') {
            lcd.cls();
            lcd.writeString(24, 2, "System", NORMAL);
            lcd.writeString(22, 3, "Restart", NORMAL);
            led1_bright += 1.0;
            led2_bright += 1.0;
            led3_bright += 1.0;
            led4_bright += 1.0;
            led1 = led1_bright;
            led2 = led2_bright;
            led3 = led3_bright;
            led4 = led4_bright;
            wait(2);
            NVIC_SystemReset();
        }
    }
}