// Scout Schultz
// ECE4180 Lab 4 Project - Remote Procedure Call Bot

#include "mbed.h"
#include "mbed_rpc.h"
#include "uLCD_4DGL.h"

// Serial Interface - Comment Out One of the Two Lines and Uncomment The Other
Serial pc(p28,p27); //BlueTooth Control
//Serial pc(USBTX, USBRX); //PC Serial USB Control: For Testing Only

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
RpcDigitalOut led4(LED4,"led4");

// uLCD Setup
uLCD_4DGL uLCD(p9,p10,p11); // serial tx, serial rx, reset pin;
int bgColor = 0x000000;
int fgColor = 0xFFFFFF;

// Set up the motor pins
PwmOut motorACtrl(p26);
PwmOut motorBCtrl(p21);
DigitalOut backA(p25);
DigitalOut fwdA(p24);
//DigitalOut stby(p18);
DigitalOut fwdB(p23);
DigitalOut backB(p22);

void updateFace();

void drive(Arguments * input, Reply * output)
{
    // Reset for simplicity sake
    fwdA=0;
    fwdB=0;
    backA=0;
    backB=0;
    double speedL = input->getArg<double>();
    double speedR = input->getArg<double>();
    if(speedL < 0) {
        speedL = -speedL;
        backB = 1;
    } else if(speedL > 0) {
        fwdB = 1;
    }

    if(speedR < 0) {
        speedR = -speedR;
        backA = 1;
    } else if(speedR > 0) {
        fwdA = 1;
    }

    motorBCtrl = speedL;
    motorACtrl = speedR;
    updateFace();
}

RPCFunction setDrive(&drive,"drive");

void updateFace()
{
    float fwdSurprise = 0.7;
    float backSurprise = 0.4;
    uLCD.cls();

    // Too Fast is Scary
    if( fwdA==1 && motorACtrl>fwdSurprise || fwdB==1 && motorBCtrl>fwdSurprise || backA==1 && motorACtrl>backSurprise || backB==1 && motorBCtrl>backSurprise) {
        uLCD.cls();
        //Open-Circle Mouth
        uLCD.filled_circle(64,80,20,fgColor);
        uLCD.filled_circle(64,80,15,bgColor);
        //Eyes
        uLCD.filled_circle(28,50,10,fgColor);
        uLCD.filled_circle(100,50,10,fgColor);
    }
    // Stationary is Boring
    else if( fwdA==0 && fwdB==0 && backA==0 && backB==0 ) {
        uLCD.cls();
        //Straight-Line Mouth
        uLCD.filled_rectangle(34,77,94,82,fgColor);
        //Eyes
        uLCD.filled_circle(28,50,10,fgColor);
        uLCD.filled_circle(100,50,10,fgColor);
    }
    // Nice movement speed is nice
    else {
        //Smile
        uLCD.filled_circle(64,70,30,fgColor);
        uLCD.filled_circle(64,70,25,bgColor);
        uLCD.filled_rectangle(0,0,128,70,bgColor);
        //Eyes
        uLCD.filled_circle(28,50,10,fgColor);
        uLCD.filled_circle(100,50,10,fgColor);
    }
}


int main()
{
    updateFace();

    // receive commands, and send back the responses
    char buf[256], outbuf[256];
    while(1) {
        if(pc.readable()) {
            pc.gets(buf, 256);
            strcat(buf, "\r"); //add LF to BlueFruit input
            led2 = !led2;
            //Call the call method on the RPC class
            RPC::call(buf, outbuf);
            pc.printf("%s\n", outbuf);
        }
        led1= !led1;
        wait(0.2); //wait 200 ms
    }
}
