#include "mbed.h"
#include "MTS_SPI_Slave.h"
#include "MTSLog.h"
#include <Thread.h>
Serial mts_debug(USBTX, USBRX); //DEBUG

using namespace mts;
MTS_SPI_Slave::MTS_SPI_Slave(PinName mosi, PinName miso, PinName sclk, PinName ssel, int txBufferSize, int rxBufferSize)
    : MTSBufferedIO(txBufferSize, rxBufferSize)
    , spi(mosi,miso,sclk,ssel)
    , thread()

{
   mts_debug.baud(115200); //DEBUG
   thread.start(this, &MTS_SPI_Slave::polling_Read);

   
   
}

MTS_SPI_Slave::~MTS_SPI_Slave()
{
}

 void MTS_SPI_Slave::polling_Read(){
        while(true){
            if(this->receive()){
                this->handleRead();
                }
            thread.wait(2000); // 2 micro seconds
            }
    }

void MTS_SPI_Slave::frequency(int frequency)
{
   spi.frequency(frequency);
}

void MTS_SPI_Slave::format(int format_bits,int format_mode)
{
    spi.format(format_bits,format_mode);
}

int MTS_SPI_Slave::receive(){
    return spi.receive();
}

void MTS_SPI_Slave::handleRead(){
    
    char byte = spi.read();
    mts_debug.printf("MTS - handleRead() executed, recieved byte: %c \n\r",byte);
    if(rxBuffer.write(byte) != 1) {
        logError("SPI Rx Byte Dropped [%c][0x%02X]", byte, byte);
    }
}
    
void MTS_SPI_Slave::handleWrite(){
        while(txBuffer.size() != 0) {
            char byte;
            if(txBuffer.read(byte)==1){
                spi.reply(byte);
                }
            else{
                return;
                }
        }
}

