#include "mbed.h"
#include "MTS_SPI_Slave.h"
#include "MTSLog.h"
#include <Thread.h>

using namespace mts;
Serial debug(USBTX, USBRX); //DELETE

MTS_SPI_Slave::MTS_SPI_Slave(PinName mosi, PinName miso, PinName sclk, PinName ssel, int txBufferSize, int rxBufferSize)
    : MTSBufferedIO(txBufferSize, rxBufferSize)
    , spi(mosi,miso,sclk,ssel)
    , _thread(new Thread)

{
   //this is where you are going to have a thread that is constantly polling to see if data has been sent, having the thread go to sleep in the time inbetween the polling

   
   debug.baud(115200); //DELETE
  // _thread->start(this, &MTS_SPI_Slave::recieved_Read);
   osStatus status = _thread->start(this, &MTS_SPI_Slave::recieved_Read);
        if (status != osOK) {
            debug.printf("Thread is not OK");
        }
   debug.printf("Thread state:  %d\n\r",_thread->get_state());
}

MTS_SPI_Slave::~MTS_SPI_Slave()
{
}

void MTS_SPI_Slave::recieved_Read(){
            debug.printf("Outside While\n\r");
        while(true){
           // debug.printf("Within While\n\r");
            if(this->receive()){
                 debug.printf("Recieved\n\r");
                this->handleRead();
                }
            }
    }

void MTS_SPI_Slave::frequency(int frequency)
{
   spi.frequency(frequency);
}

void MTS_SPI_Slave::format(int format_bits,int format_mode)
{
    spi.format(format_bits,format_mode);
}

int MTS_SPI_Slave::receive(){
    return spi.receive();
}

void MTS_SPI_Slave::handleRead(){
    
    int byte = spi.read();
    debug.printf("handleRead() executed with byte: %c \n\r",byte);
    if(rxBuffer.write((char)byte) != 1) {
        logError("SPI Rx Byte Dropped [%c][0x%02X]", byte, byte);
    }
}
    
void MTS_SPI_Slave::handleWrite(){
        while(txBuffer.size() != 0) {
            char byte;
            if(txBuffer.read(byte)==1){
                spi.reply(byte);
                }
            else{
                return;
                }
        }
}

