#ifndef AT_SPI_Slave_H
#define AT_SPI_Slave_H

#include "MTS_SPI_Slave.h"
#include "MTSBufferedIO.h"

namespace mts
{

class AT_SPI_Slave : public MTS_SPI_Slave
{
public:

    

    AT_SPI_Slave(PinName mosi, PinName miso, PinName sclk, PinName ssel, int txBufferSize = 256, int rxBufferSize = 256);

    virtual ~AT_SPI_Slave();

    void frequency(int frequency); //old

    void format(int format_bits=8,int format_mode=0); //old

    void sendBreak(); //new

    bool escaped(); //new 

    void escapeChar(char esc); //new 

    char escapeChar(); //new

    void clearEscaped(); //new 


protected:

    SPISlave* _spi; // Internal mbed Serial object
    Thread* _thread;
    int _frequency;
    int _format_bits;
    int _format_mode;

    int _stop_bits;
    Timer timer;
    int _last_time;
    int _esc_cnt;
    char _esc_ch;
    bool _escaped;

    virtual void polling_Read(); 
    virtual void handleWrite(); // Method for handling data to be written
    virtual void handleRead(); // Method for handling data to be read
    virtual int receive();  //polls the spi to see if anything has been recieved


};

}

#endif /* AT_SPI_Slave_H */
