#include "mbed.h"
#include "AT_SPI_Slave.h"
#include "MTSLog.h"

using namespace mts;
Serial debug(USBTX, USBRX); //DEBUG

AT_SPI_Slave::AT_SPI_Slave(PinName mosi, PinName miso, PinName sclk, PinName ssel, int txBufferSize, int rxBufferSize)
    : MTS_SPI_Slave(mosi,miso,sclk,ssel,txBufferSize, rxBufferSize)
    , _spi(new SPISlave(mosi,miso,sclk,ssel))
    , _thread(new Thread),
    
    _frequency(1000000),
    _format_bits(8),
    _format_mode(0),
    _stop_bits(1),
    _last_time(0),
    _esc_cnt(0),
    _esc_ch('+'),
    _escaped(false)
{
    debug.baud(115200);
    _thread->start(this, &AT_SPI_Slave::polling_Read);
    timer.start();
}

AT_SPI_Slave::~AT_SPI_Slave()
{
    delete _spi;
    delete _thread;
}
void AT_SPI_Slave::polling_Read()
{
        while(true){
            if(this->receive()){
                this->handleRead();
            }
            thread.wait(2000); // 2 micro seconds
        }
}

void AT_SPI_Slave::frequency(int frequency)
{
    _frequency = frequency;
    _spi->frequency(_frequency);
}

void AT_SPI_Slave::format(int format_bits, int format_mode)
{
    _format_bits = format_bits;
    _format_mode = format_mode;
    _spi->format(_format_bits,_format_mode);
}

int AT_SPI_Slave::receive()
{
    return _spi->receive();      
}

void AT_SPI_Slave::handleWrite()
{
        while(txBuffer.size() != 0) {
            char byte;
            if(txBuffer.read(byte)==1){
                _spi->reply(byte);
                }
            else{
                return;
                }
        }
}

bool AT_SPI_Slave::escaped() {

    int now = timer.read_ms();

    // Have we seen three esc chars and 1 sec end guard has passed
    if (_escaped || (_esc_cnt == 3 && (now - _last_time > 1000))) {
        _escaped = true;
        return true;

    // Have we seen a couple esc chars but nothing in 500 ms
    } else if (_esc_cnt > 0 && _esc_cnt != 3 && now - _last_time > 500) {
        // Write seen esc chars
        while (_esc_cnt) {
            rxBuffer.write(_esc_ch);
            _esc_cnt--;
        }
    }

    return false;
}

void AT_SPI_Slave::clearEscaped() {
    _esc_cnt = 0;
    _escaped = false;
}

void AT_SPI_Slave::handleRead()
{

    char byte = _spi->read();
    debug.printf("Cur char: %c\n\r",byte);
    int now = timer.read_ms();

    // Have we seen 3 esc chars but this char is before 1 sec end guard time
    if (_esc_cnt == 3 && (now - _last_time < 1000)) {
        debug.printf("1");
        // Write the three chars we held back
        while (_esc_cnt) {
            rxBuffer.write(_esc_ch);
            _esc_cnt--;
        }
    } else if (byte == _esc_ch) {
        debug.printf("2");
        // Has 1 second passed before last char
        if (now - _last_time > 1000) {
            _esc_cnt = 1;
        // Is this second or third esc char
        } else if (_esc_cnt > 0 && _esc_cnt < 3) {
            _esc_cnt++;
        }
    } else if (_esc_cnt > 0) {
        debug.printf("3");
        // Write any esc chars held back
        while (_esc_cnt) {
            rxBuffer.write(_esc_ch);
            _esc_cnt--;
        }
    }

    if(_esc_cnt == 0 && rxBuffer.write(byte) != 1) {
         logError("Serial Rx Byte Dropped [%c][0x%02X]", byte, byte);
    }

    _last_time = timer.read_ms();
}

void AT_SPI_Slave::escapeChar(char esc) {
    _esc_ch = esc;
}

char AT_SPI_Slave::escapeChar() {
    return _esc_ch;
}