#include "mbed.h"

#include "mtsas.h"

#include "MQTTTimer.h"
#include "CayenneMQTTClient.h"
#include "MQTTNetwork.h"

#include "x_nucleo_iks01a1.h"

#include <string>
#include <sstream>

using std::string;
typedef CayenneMQTT::MQTTClient<MQTTNetwork<Cellular>, MQTTTimer> MQTTClient;

// Cayenne authentication info. This should be obtained from the Cayenne Dashboard.
string username = "3f842710-8e51-11e7-a5d9-9de9b49680ec";
string password = "46f0e2add1dbcd1d7cab6fde2a2b93c4423a377a";
string clientID = "b0358dd0-8f43-11e7-b153-197ebdab87be";

DigitalOut Led1Out(LED1);

// Debug serial port
//static Serial debug(USBTX, USBRX);
Serial pc(USBTX, USBRX);
// MTSSerialFlowControl - serial link between processor and radio
static MTSSerialFlowControl* io;

// Cellular - radio object for cellular operations (SMS, TCP, etc)
Cellular* radio;

/* Instantiate the expansion board */
static X_NUCLEO_IKS01A1 *mems_expansion_board = X_NUCLEO_IKS01A1::Instance(I2C_SDA, I2C_SCL);

/* Retrieve the composing elements of the expansion board */
static GyroSensor *gyroscope = mems_expansion_board->GetGyroscope();
static MotionSensor *accelerometer = mems_expansion_board->GetAccelerometer();
static MagneticSensor *magnetometer = mems_expansion_board->magnetometer;
static HumiditySensor *humidity_sensor = mems_expansion_board->ht_sensor;
static PressureSensor *pressure_sensor = mems_expansion_board->pt_sensor;
static TempSensor *temp_sensor1 = mems_expansion_board->ht_sensor;
static TempSensor *temp_sensor2 = mems_expansion_board->pt_sensor;


CayenneMQTT::MessageData lastMessage;
bool messageReady;

/*
* Initialize cellular radio.
*/
bool init_mtsas()
{

    io = new MTSSerialFlowControl(D8,D2,D3,D6);//This is the only thing that I have changed!
    if (! io)
        return false;
    
    io->baud(115200);
    radio = CellularFactory::create(io);
    if (! radio)
        return false;

    //radio->setApn("wireless.twilio.com");
    Transport::setTransport(radio);
    while (! radio->connect()) {
        logError("failed to bring up PPP link");
        wait(2);
    }
    
    printf("Signal Strength: %d\n\r", radio->getSignalStrength()); 
    return true;
}

/**
* Print the message info.
* @param[in] message The message received from the Cayenne server.
*/
void outputMessage(CayenneMQTT::MessageData& message)
{
    switch (message.topic)  {
    case COMMAND_TOPIC:
        pc.printf("topic=Command");
        break;
    case CONFIG_TOPIC:
        printf("topic=Config");
        break;
    default:
        printf("topic=%d", message.topic);
        break;
    }
    printf(" channel=%d", message.channel);
    if (message.clientID) {
        printf(" clientID=%s", message.clientID);
    }
    if (message.type) {
        printf(" type=%s", message.type);
    }
    for (size_t i = 0; i < message.valueCount; ++i) {
        if (message.getValue(i)) {
            printf(" value=%s", message.getValue(i));
        }
        if (message.getUnit(i)) {
            printf(" unit=%s", message.getUnit(i));
        }
    }
    if (message.id) {
        printf(" id=%s", message.id);
    }
    printf("\r\n");
}

/**
* Handle messages received from the Cayenne server.
* @param[in] message The message received from the Cayenne server.
*/
void messageArrived(CayenneMQTT::MessageData& message)
{
    int error = 0;
    //note: if you change this example to use mbed-os you will need a mutex
    lastMessage = message;
    messageReady = true;

}

/**
* Connect to the Cayenne server.
* @return Returns CAYENNE_SUCCESS if the connection succeeds, or an error code otherwise.
*/
int connectClient(MQTTClient &mqttClient, MQTTNetwork<Cellular> &network)
{
    int error = 0;
    // Connect to the server.
    printf("Connecting to %s:%d\r\n", CAYENNE_DOMAIN, CAYENNE_PORT);
    while ((error = network.connect(CAYENNE_DOMAIN, CAYENNE_PORT)) != 0) {
        printf("TCP connect failed, error: %d\r\n", error);
        wait(2);
    }

    if ((error = mqttClient.connect()) != MQTT::SUCCESS) {
        printf("MQTT connect failed, error: %d\r\n", error);
        return error;
    }
    printf("Connected\r\n");

    // Subscribe to required topics.
    if ((error = mqttClient.subscribe(COMMAND_TOPIC, CAYENNE_ALL_CHANNELS)) != CAYENNE_SUCCESS) {
        printf("Subscription to Command topic failed, error: %d\r\n", error);
    }
    if ((error = mqttClient.subscribe(CONFIG_TOPIC, CAYENNE_ALL_CHANNELS)) != CAYENNE_SUCCESS) {
        printf("Subscription to Config topic failed, error:%d\r\n", error);
    }

    // Send device info. Here we just send some example values for the system info. These should be changed to use actual system data, or removed if not needed.
    mqttClient.publishData(SYS_VERSION_TOPIC, CAYENNE_NO_CHANNEL, NULL, NULL, CAYENNE_VERSION);
    mqttClient.publishData(SYS_MODEL_TOPIC, CAYENNE_NO_CHANNEL, NULL, NULL, "mbedDevice");
    //mqttClient.publishData(SYS_CPU_MODEL_TOPIC, CAYENNE_NO_CHANNEL, NULL, NULL, "CPU Model");
    //mqttClient.publishData(SYS_CPU_SPEED_TOPIC, CAYENNE_NO_CHANNEL, NULL, NULL, "1000000000");

    return CAYENNE_SUCCESS;
}

/**
* Main loop where MQTT code is run.
*/
void loop(MQTTClient &mqttClient, MQTTNetwork<Cellular> &network)
{
    // Start the countdown timer for publishing data every 5 seconds. Change the timeout parameter to publish at a different interval.
    MQTTTimer timer(1000);
    printf("Starting loop.\r\n");
    while (true) {
        // Yield to allow MQTT message processing.
        mqttClient.yield(10);
        if(messageReady){
            int error = 0;
            messageReady = false;
            // Add code to process the message. Here we just ouput the message data.
            outputMessage(lastMessage);
        
            if (lastMessage.topic == COMMAND_TOPIC) {
                switch(lastMessage.channel) {
                case 0:
                    // Set the onboard LED state
                    Led1Out = atoi(lastMessage.getValue());
                    // Publish the updated LED state
                    if ((error = mqttClient.publishData(DATA_TOPIC, lastMessage.channel, NULL, NULL, Led1Out.read())) != CAYENNE_SUCCESS) {
                        printf("Publish LED state failure, error: %d\r\n", error);
                    }
                    break;
                }
                
                // If this is a command message we publish a response. Here we are just sending a default 'OK' response.
                // An error response should be sent if there are issues processing the message.
                if ((error = mqttClient.publishResponse(lastMessage.id, NULL, lastMessage.clientID)) != CAYENNE_SUCCESS) {
                    printf("Response failure, error: %d\r\n", error);
                }
            }
        }

        // Check that we are still connected, if not, reconnect.
        if (!network.connected() || !mqttClient.connected()) {
            network.disconnect();
            mqttClient.disconnect();
            printf("Reconnecting\r\n");
            while (connectClient(mqttClient, network) != CAYENNE_SUCCESS) {
                wait(2);
                printf("Reconnect failed, retrying\r\n");
            }
        }

        // Publish some example data every few seconds. This should be changed to send your actual data to Cayenne.
        if (timer.expired()) {
            int error = 0;
            float temp_data;
            temp_sensor1->get_temperature(&temp_data);
            printf("Temperature was: %f \r\n", temp_data);
            if ((error = mqttClient.publishData(DATA_TOPIC, 1, TYPE_TEMPERATURE, UNIT_CELSIUS, temp_data)) != CAYENNE_SUCCESS) {
                printf("Publish temperature failed, error: %d\r\n", error);
            }
            humidity_sensor->get_humidity(&temp_data);
            printf("Humidity was: %f \r\n", temp_data);
            if ((error = mqttClient.publishData(DATA_TOPIC, 2, TYPE_RELATIVE_HUMIDITY, UNIT_PERCENT, temp_data)) != CAYENNE_SUCCESS) {
                printf("Publish luminosity failed, error: %d\r\n", error);
            }
            pressure_sensor->get_pressure(&temp_data);
            printf("Pressure was: %f \r\n", temp_data);
            if ((error = mqttClient.publishData(DATA_TOPIC, 3, TYPE_BAROMETRIC_PRESSURE, UNIT_HECTOPASCAL, temp_data)) != CAYENNE_SUCCESS) {
                printf("Publish barometric pressure failed, error: %d\r\n", error);
            }
            printf("Led is: %s\r\n", Led1Out.read() ? "on" : "off");
             if ((error = mqttClient.publishData(DATA_TOPIC, 0, "digital_actuator", UNIT_DIGITAL, Led1Out.read())) != CAYENNE_SUCCESS) {
                printf("Publish LED status failed, error: %d\r\n", error);
            }
            // Restart the countdown timer for publishing data every 5 seconds. Change the timeout parameter to publish at a different interval.
            timer.countdown_ms(5000);
        } else {
           // debug
           // printf("Timer: %d", timer.left_ms());
        }
    }
}

int main()
{
    pc.baud(115200);
    Led1Out = 0;
    mts::MTSLog::setLogLevel(mts::MTSLog::TRACE_LEVEL);
    // init radio, setup Cayenne connection
    if (!init_mtsas()) {
        while (true) {
            logError("failed to initialize cellular radio");
            wait(1);
        }
    }
    // Test with a ping
    if(radio->ping("www.google.com")){
        printf("Ping test succeeded!\r\n");
    } else {
        printf("Failed ping test!\r\n");
    }
    MQTTNetwork<Cellular> network(*radio);
    messageReady = false;
    MQTTClient mqttClient(network, username.c_str(), password.c_str(), clientID.c_str());

    // Set the default function that receives Cayenne messages.
    mqttClient.setDefaultMessageHandler(messageArrived);

    // Connect to Cayenne.
    if (connectClient(mqttClient, network) == CAYENNE_SUCCESS) {
        // Run main loop.
        loop(mqttClient, network);
    }
    else {
        printf("Connection failed, exiting\r\n");
    }

    if (mqttClient.connected())
        mqttClient.disconnect();
    if (network.connected())
        network.disconnect();
    
    return 0;
}
