/* Copyright (c) <2016> <MultiTech Systems>, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef __LAYOUTSWEEPCOMPLETE_H__
#define __LAYOUTSWEEPCOMPLETE_H__

#include "Layout.h"

class LayoutSweepComplete : public Layout {
    public:
        LayoutSweepComplete(DOGS102* lcd);
        ~LayoutSweepComplete();

        void display();
        void updateId(uint32_t id);
        void updatePass(uint8_t pass);
        void updateFail(uint8_t fail);

    private:
        Label _lId;
        Label _lInfo;
        Label _lPass;
        Label _lFail;
        Label _lSw2;
        
        Field _fId;
        Field _fPass;
        Field _fFail;
};

#endif
