/* Copyright (c) <2016> <MultiTech Systems>, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
//THIS CUSTOM INSTALLER ASSISTANT, WORKS WITH mbed-os 5.1.2 and mdot lib 5.1.5
#include "ModeSingle.h"
#include "MTSLog.h"

#include "font_6x8.h"
#include <string>
#include <sstream>
ModeSingle::ModeSingle(DOGS102* lcd, ButtonHandler* buttons, mDot* dot, LoRaHandler* lora, GPSPARSER* gps, SensorHandler* sensors)
  : Mode(lcd, buttons, dot, lora, gps, sensors),
    _help(lcd),
    _file(lcd),
    _confirm(lcd),
    _progress(lcd),
    _success(lcd),
    _failure(lcd)
{}
ModeSingle::~ModeSingle() {}

bool ModeSingle::start() {

    
    bool send_link_check = false;
    bool send_data = false;
    bool no_channel_link_check = false;
    bool no_channel_data = false;

    // clear any stale signals
    osSignalClear(_main_id, buttonSignal | loraSignal);
    
    _initial_data_rate = _dot->getTxDataRate();
    _initial_power = _dot->getTxPower();

    // see if we're supposed to send the data packet after success
    // that item is stored in the mDot::StartUpMode config field
   // _send_data = _dot->getStartUpMode();


//           Stating Start up Values for the Power, DataRate and State
//________________________________________________________________________________________________________
_power = 20;                //Hard setting the power, user dose not need to change it so we state it here
_data_rate = mDot::DR0;     //setting the data rate, going to be increasead by 1 increments
_state = 4;                 //setting the state so it goes right into success behavior off the start


//Initalizing Variables for converting the RSSI int value into a string
//_____________________________________________________________________
 string rssiStringHolder;
 int rssiIntHolder;
 ostringstream rssiConverter;
 Label rssiLabel(0,3,"RSSI");
 
 string dataRateStringHolder;
 int dataRateIntHolder;
 ostringstream dataRateConverter;
 Label dataRateLabel(0,6,"Data");
 
 string marginStringHolder;
 int marginIntHolder;
 ostringstream marginConverter;
 Label marginLabel(0,2,"Margin1");

//          Initial Settings for the LCD Display
//________________________________________________________________________________________________________
_lcd->startUpdate();    
_lcd->clearBuffer();        //Clears the LCD
_lcd->writeText(0*6, 0, font_6x8, "    Installer    ", 17);
_lcd->writeText(0*6, 1, font_6x8, "    Assistant    ", 17);
_lcd->writeText(0*6, 5, font_6x8, "Power=20         ", 17);

dataRateIntHolder = _data_rate;
dataRateConverter.str("");
dataRateConverter.clear();
dataRateConverter << dataRateIntHolder;
dataRateStringHolder = dataRateConverter.str();
dataRateLabel._value = "DataRate=" + dataRateStringHolder;
_success.writeLabel(dataRateLabel);
//_success.updateInfo(formatRatePower()); //This Displays the updated DataRate value, it changes so we cant just display the number itsself

_lcd->endUpdate();
_success.updateSw1("DataRate");
_success.updateSw2("Survey");

    while (true) {
        osEvent e = Thread::signal_wait(0, 250);
        if (e.status == osEventSignal) {
            if (e.value.signals & buttonSignal) {
                _be = _buttons->getButtonEvent();

                switch (_be) {
                    case ButtonHandler::sw1_press:
                        switch (_state) {
                            case success:
                                incrementRatePower();
                                
                                logInfo("\n\r\n\r I am within the DataRate button press! \n\r");
                                
                                dataRateIntHolder = _data_rate;
                                dataRateConverter.str("");
                                dataRateConverter.clear();
                                dataRateConverter << dataRateIntHolder;
                                dataRateStringHolder = dataRateConverter.str();
                                
                                dataRateLabel._value = "DataRate=" + dataRateStringHolder;
                                
                                
                                _lcd->startUpdate();  
                                _success.writeLabel(dataRateLabel);
                                _lcd->endUpdate();

                
                                break;
                            case failure:
                                incrementRatePower();
                                
                                dataRateIntHolder = _data_rate;
                                dataRateConverter.str("");
                                dataRateConverter.clear();
                                dataRateConverter << dataRateIntHolder;
                                dataRateStringHolder = dataRateConverter.str();
                                
                                dataRateLabel._value = "DataRate=" + dataRateStringHolder;
                                
                                
                                _lcd->startUpdate();  
                                _success.writeLabel(dataRateLabel);
                                _lcd->endUpdate();
                                break;
                        }
                        break;

                    case ButtonHandler::sw2_press:
                        switch (_state) {
                            case success:
                                _state = in_progress;
                                _progress.display(); //this is where the survey in progress is located
                                if (_dot->getNextTxMs() > 0)
                                    no_channel_link_check = true;
                                else 
                                    send_link_check = true;
                                break;
                            case failure:
                                _state = in_progress;
                                _progress.display();
                                if (_dot->getNextTxMs() > 0)
                                    no_channel_link_check = true;
                                else 
                                    send_link_check = true;
                                break;
                        }
                        break;
                }
            }
            if (e.value.signals & loraSignal) {
                _ls = _lora->getStatus();
                switch (_ls) {
                    case LoRaHandler::link_check_success:
                    
                        switch (_state) {
                            case in_progress:
                                _link_check_result = _lora->getLinkCheckResults();//Where the RSSI value lies
                                //converting the RSSI int value to a string and then creating a new label that can be written to the LCD
                                //______________________________________________________________________________
                                rssiIntHolder = _link_check_result.down.rssi;
                                rssiConverter.str("");
                                rssiConverter.clear();
                                rssiConverter << rssiIntHolder;
                                rssiStringHolder = rssiConverter.str();
                                rssiStringHolder = "Rssi= " + rssiStringHolder + "dBm";
        
                                rssiLabel._value = rssiStringHolder;
                                
                                
                                marginIntHolder = _link_check_result.up.dBm;
                                marginConverter.str("");
                                marginConverter.clear();
                                marginConverter << marginIntHolder;
                                marginStringHolder = marginConverter.str();
                                marginStringHolder = "Margin= " + marginStringHolder + "dBm";
        
                                marginLabel._value = marginStringHolder;
                                
                                
                                dataRateIntHolder = _data_rate;
                                dataRateConverter.str("");
                                dataRateConverter.clear();
                                dataRateConverter << dataRateIntHolder;
                                dataRateStringHolder = dataRateConverter.str();
                                
                                dataRateLabel._value = "DataRate=" + dataRateStringHolder;
                               
                                //writing to the LCD the RSSI value as well as the other information
                                //_________________________________________________________________
                                _lcd->startUpdate();
                                _lcd->clearBuffer();
                                _lcd->writeText(0*6, 0, font_6x8, "    Installer    ", 17);
                                _lcd->writeText(0*6, 1, font_6x8, "    Assistant    ", 17);
                                _lcd->writeText(0*6, 5, font_6x8, "Power=20         ", 17);
                                
                               // _success.updateInfo(formatRatePower());
                                _success.writeLabel(rssiLabel);
                                _success.writeLabel(marginLabel);
                                _success.writeLabel(dataRateLabel);
                                _lcd->endUpdate();
                                
                                logInfo("link check successful\tMargin %ld\tRSSI %d dBm\tSNR %2.3f", _link_check_result.up.dBm, _link_check_result.down.rssi, (float)_link_check_result.down.snr / 10.0);

                                _state = success;
                                _success.updateSw1("DataRate");
                                _success.updateSw2("Survey");
                        }
                        break;

                    case LoRaHandler::link_check_failure:
                        switch (_state) {
                            case in_progress:
                                _state = failure;
                                
                                dataRateIntHolder = _data_rate;
                                dataRateConverter.str("");
                                dataRateConverter.clear();
                                dataRateConverter << dataRateIntHolder;
                                dataRateStringHolder = dataRateConverter.str();
                                
                                dataRateLabel._value = "DataRate=" + dataRateStringHolder;
                                
                                //writing to the LCD the RSSI value as well as the other information
                                //_________________________________________________________________
                                _lcd->startUpdate();                                
                                _lcd->clearBuffer();
                                _lcd->writeText(0*6, 0, font_6x8, "    Installer    ", 17);
                                _lcd->writeText(0*6, 1, font_6x8, "    Assistant    ", 17);
                                _lcd->writeText(0*6, 5, font_6x8, "Power=20         ", 17);
                                _lcd->writeText(0*6, 3, font_6x8, "Unable to Connect", 17);
                                _lcd->endUpdate();
                               // _success.updateInfo(formatRatePower());
                               
                                _success.writeLabel(dataRateLabel);
                                _failure.updateSw1("DataRate");
                                _failure.updateSw2("Survey");              
                                logInfo("link check failed");
                                break;
                        }
                        break;
                }
            }
        }

        if (send_link_check) {
            logInfo("sending link check %s %d", _dot->DataRateStr(_data_rate).c_str(), _power);
            send_link_check = false;
            _dot->setTxDataRate(_data_rate);
            _dot->setTxPower(_power);
            _lora->linkCheck();
            _index++;
        }
    }

}



//Cycles the datarates through from DR0-DR4
void ModeSingle::incrementRatePower() {
    if(_data_rate == mDot::DR4){
        _data_rate = mDot::DR0;
        }
    else{
        _data_rate++;
        }
    logInfo("new data rate %s, power %lu", mDot::DataRateStr(_data_rate).c_str(), _power);
}

