#include "system.h"


void Alive()         // ticker routine
{
    SendAlive = 1;
}

void button_pressed()   // irq routine for button
{
    ButtonPressed = 1;
}


void onUDPSocketEvent(UDPSocketEvent e)
{
  switch(e)
  {
  case UDPSOCKET_READABLE: //The only event for now
    char buf[64] = {0};
    Host host;
    while( int len = udp.recvfrom( buf, 63, &host ) )
    {
      if( len <= 0 )
        break;
        
        // should implement a parser...
        // but this will do the trick for the moment
        if ( strncmp ( buf, "MBED", 4 ) == 0 )
        {
            //pc.printf ("message from %d.%d.%d.%d: %s\n", host.getIp()[0], host.getIp()[1], host.getIp()[2], host.getIp()[3], buf );

            mbed_client = 0;
            for ( int i = 5; i < 8; i++ )
            {
                if ( ( buf[i] >= '0' ) & ( buf[i] <= '9' ) ) { mbed_client *=10; mbed_client += ( buf[i] - '0' ); }
            }
            if ( strstr (buf, "ALIVE") != NULL )
            {
                pc.printf ("MBED %d is alive\n\r", mbed_client );
            }
            if ( strstr (buf, "LED") != NULL )
            {
                pc.printf ("Message for MBED %d\n\r", mbed_client );
                if ( strstr (buf, "ON")  != NULL ) { led = 1; }
                if ( strstr (buf, "OFF") != NULL ) { led = 0; }
            }
        }
    }
    break;
  }
}

int main() {
  char pos = 0;
  pc.baud(115200);
  pc.printf("Ethernet...\n\r");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    pc.printf("Error %d in setup.\n\r", ethErr);
    return -1;
  }
  pc.printf("  OK\n\r");
  IpAddr ethIp = eth.getIp();
  mbed_id = ethIp[3];
  sprintf( strAlive, "MBED %d ALIVE\0", mbed_id );

  pc.printf( "%s\n\r", strAlive );

    /* Set up NTP */
//    lcd.printf("Setting up NTP\n");
    Host server(IpAddr(), 123, "0.uk.pool.ntp.org");
    ntp.setTime(server);
    /* Temporary variables for control loop */
    time_t rtc_time = time(NULL);
    int minute = -1;


  // set Alive Broadcast to 10 seconds
  AliveTicker.attach(&Alive, 10);  
  Host multicast(IpAddr(239, 192, 1, 100), 50000, NULL); //Join multicast group on port 50000
 
  udp.setOnEvent(&onUDPSocketEvent);
  
  udp.bind(multicast);

  udp.sendto( strAlive, strlen(strAlive), &multicast );
  
  button.rise(&button_pressed);
  while( 1 ) // Never Ending Story by Michael Ende
  {
    Net::poll();
    if ( SendAlive == 1 ) { udp.sendto( strAlive, strlen(strAlive), &multicast ); SendAlive = 0; }    // Send Alive Signal
    
    if( ButtonPressed != 0 )
    {
      char strout[20];
      pos = !pos;
      if ( pos == 0 ) sprintf( strout, "MBED %d LED OFF\0", mbed_client ); else sprintf( strout, "MBED %d LED ON\0", mbed_client );
      udp.sendto( strout, strlen(strout), &multicast );
      //pc.printf("%s\n", str);
      ButtonPressed = 0;
    }

        /* Update current time */
        rtc_time = time(NULL);
        cTime = localtime(&rtc_time);
        if (cTime->tm_min != minute)
        {
            pc.printf("*** %d:%d ***\n\r", cTime->tm_hour, cTime->tm_min);
            minute = cTime->tm_min;
            /* Update time from NTP server if it's midnight UTC */
            if ((cTime->tm_min == 0) && (cTime->tm_hour == 0))
            {
                Host server(IpAddr(), 123, "0.uk.pool.ntp.org");
                ntp.setTime(server);
            }
        }

  }

  
}
