/*
* Authors: Group 4 Adam Elghor, Brian Kaplan, Sayak Chatterjee, Moraa Onwonga
* Purpose: Controls the functions of the safe
* Language: C
*/
#include "open.h"
#include "lock.h"
#include "setup.h"
#include "parameters.h"
#include "authentication.h"



enum states state = SETUP;

/*
* Function:  SafeStateMachine
* --------------------
*  Routine for the safe's basic functions.
*
*
*
*/
void SafeStateMachine()
{
    while (1) {
        switch (state) {
        case OPEN:/*state in which the the case is open*/
            state = open();
            break;
        case LOCK:/*state in which the case us closed*/
            state = lock();
            break;
        case SETUP:/*state in which the the case is changing its settings*/
            state = setup();
            break;
        default:
            state = lock();
        }
        wait(.5);
        
    }
}

int main() {
    start_bluetooth();
    SafeStateMachine();
}




