/*
* Authors: Group 4 Adam Elghor, Brian Kaplan, Sayak Chatterjee, Moraa Onwonga
* Purpose: Controls Input and Output Data
* Language: C
*/
#include "authentication.h"
#include "powerManagement.h"
#include "parameters.h"

int p1;
int p2;
int p3;
int p4;

int entryNum1;
int entryNum2;
int entryNum3;
int entryNum4;


AnalogIn pot1(p15);
AnalogIn pot2(p16);
AnalogIn pot3(p18);
AnalogIn pot4(p19);

bool bluetoothCode = false;
bool bluetoothSetup = false;
Serial blue(p28,p27);
Serial pc(USBTX, USBRX);

/*
* Function: setEntrySequence
* --------------------
*  Reads in user's entry sequence attempt
*/
void setEntrySequenceAttempt() {
	entryNum1 = float(pot1) * 6;
	entryNum2 = float(pot2) * 6;
	entryNum3 = float(pot3) * 6;
	entryNum4 = float(pot4) * 6;
}

/*
* Function:  CorrectEntrySequenceAttempt
* --------------------
*  Checks whether the user's entry sequence attempt is correct
*
*  returns: true if the entry sequence attempt from the user matches
*  the set entry sequence otherwise false
*
*/
bool CorrectEntrySequenceAttempt() {
	if (bluetoothCode) {
		return true;

	}
	p1 = float(pot1) * 6;
	p2 = float(pot2) * 6;
	p3 = float(pot3) * 6;
	p4 = float(pot4) * 6;

	return (checkPot(p1,entryNum1) && checkPot(p2,entryNum2) && checkPot(p3,entryNum3) && checkPot(p3,entryNum3));
}

void printPotValues() {
	pc.printf("pot1 is %f", pot1);
	
}

bool checkPot(int p1, int p2) {
	return (p2 - p1) < 2 && (p1 - p2) > -2;

}

bool checkBluetooth() {
	if (bluetoothSetup) {
		bluetoothSetup = false;
		return true;
	}
	return false;
}



/*
* Function:  parse_bluetooth
* --------------------
*  bluetooth stuff EDIT LATER
*
*  returns:
*
*/
void parse_bluetooth()
{
    switch (blue.getc()) {
        case 'o':
            bluetoothCode  = true;
            break;
        case 'l':
            bluetoothCode = false;
            break;
        case 's':
			bluetoothSetup = true;
			break;
    }
    
}

void start_bluetooth() {
	 blue.attach(&parse_bluetooth, Serial::RxIrq);	
}

/*
* Function:  sdCard
* --------------------
*  sdCard stuff EDIT LATER
*
*  returns:
*
*/
void sdCard() {

}


