
#include "steppercontroller.h"

StepperController::StepperController(PinName phaseA,PinName enA, PinName phaseB, PinName enB ):
    phaseA(phaseA), enA(enA), phaseB(phaseB), enB(enB)
{
    this->enA.period(50e-6f);
    this->enB.period(50e-6f);
    pulseWidth = 0.1f;
    state = 0;
}

void StepperController::advance()
{
    state = (state + 4 + dir) & 3;
    updateOutputs();
}

void StepperController::setPeriod(float period)
{
    enA.period(period);
    enB.period(period);   
}

void StepperController::setPulseWidth(float pulseWidth)
{
    this->pulseWidth = pulseWidth;
}

void StepperController::setDirection(Direction dir)
{
    this->dir = dir;
}

void StepperController::updateOutputs()
{
    switch(state){
    case 0:
       phaseA = 1;
       enA = pulseWidth;
       phaseB = 0;
       enB = 0.0f;
       break;
    case 1:
       phaseA = 0;
       enA = pulseWidth;
       phaseB = 0;
       enB = 0.0f;
       break;

    case 2:
       phaseA = 0;
       enA = 0.0f;
       phaseB = 1;
       enB = pulseWidth;
       break;

    case 3:
       phaseA = 0;
       enA = 0.0f;
       phaseB = 0;
       enB = pulseWidth;
       break;

    default:
       phaseA = 0;
       enA = 0.0;
       phaseB = 0;
       enB = 0.0;
    }
}
    

        
        
        
        