#ifndef STEPPERCONTROLLER_H
#define STEPPERCONTROLLER_H
#include "mbed.h"

class StepperController {
    
public:
    enum Direction {DirectionCW = 1, DirectionCCW = -1};
    StepperController(PinName phaseA,PinName enA, PinName phaseB, PinName enB );
    void advance();
    void setPeriod(float period);
    void setPulseWidth(float width);
    void setDirection(Direction dir);
    
private:
    int state;
    float pulseWidth;
    DigitalOut phaseA, phaseB;
    PwmOut enA, enB;
    Direction dir;
    void updateOutputs();
   
   
};
    
 #endif   