#include "mbed.h"
#include <ctype.h>
#include "arm_math.h"
#include "arm_const_structs.h"
 
void arm_cfft_f32( 
   const arm_cfft_instance_f32 * S, 
   float32_t * p1,
   uint8_t ifftFlag,
   uint8_t bitReverseFlag);

Serial pc(USBTX, USBRX);//:D ПРИВЕТ!!!!


 
AnalogIn   left(A2);
AnalogIn   right(A3);
AnalogIn   center(A3);
 
int SAMPLE_RATE_HZ = 40000;             // Sample rate of the audio in hertz.
//const int FFT_SIZE = 16;                // Size of the FFT.
const int FFT_SIZE = 1024;                // Size of the FFT.
 
const static arm_cfft_instance_f32 *S;
//static arm_cfft_radix2_instance_f32 *S;
Ticker samplingTimer;
float samples[FFT_SIZE*2];
float samples2[FFT_SIZE*2];
float samples3[FFT_SIZE*2];

float magnitudes[FFT_SIZE];
float magnitudes2[FFT_SIZE];
float magnitudes3[FFT_SIZE];
int sampleCounter = 0;

 
void samplingCallback()
{    
    // Read from the ADC and store the sample data
    samples[sampleCounter] = 1000*left.read();
    samples2[sampleCounter] = 1000*left.read();
    samples3[sampleCounter] = 1000*left.read();
    // Complex FFT functions require a coefficient for the imaginary part of the input.
    // Since we only have real data, set this coefficient to zero.
    samples[sampleCounter+1] = 0.0;
    samples2[sampleCounter+1] = 0.0;
    samples3[sampleCounter+1] = 0.0;
    // Update sample buffer position and stop after the buffer is filled
        
    sampleCounter += 2;
    
    if (sampleCounter >= FFT_SIZE*2) {
        samplingTimer.detach();
    }
}
 
void samplingBegin()
{
    // Reset sample buffer position and start callback at necessary rate.
    sampleCounter = 0;
    samplingTimer.attach_us(&samplingCallback, (float)(1000000/SAMPLE_RATE_HZ));
}
 
bool samplingIsDone()
{
    return sampleCounter >= FFT_SIZE*2;
}
 
int main()
{
    // Set up serial port.
    //pc.baud (38400);
 
    // Init arm_ccft_32
    switch (FFT_SIZE)
    {
    case 16:
        S = & arm_cfft_sR_f32_len16;
        break;
    case 32:
        S = & arm_cfft_sR_f32_len32;
        break;
    case 64:
        S = & arm_cfft_sR_f32_len64;
        break;
    case 128:
        S = & arm_cfft_sR_f32_len128;
        break;
    case 256:
        S = & arm_cfft_sR_f32_len256;
        break;
    case 512:
        S = & arm_cfft_sR_f32_len512;
        break;
    case 1024:
        S = & arm_cfft_sR_f32_len1024;
        break;
    case 2048:
        S = & arm_cfft_sR_f32_len2048;
        break;
    case 4096:
        S = & arm_cfft_sR_f32_len4096;
        break;
    }
    float maxValue = 0.0f;
    float maxValue2 = 0.0f;
    float maxValue3 = 0.0f;
    
    unsigned int testIndex = 0;
    unsigned int testIndex2 = 0;
    unsigned int testIndex3 = 0;
 
    // Begin sampling audio
    samplingBegin();
 
    while(1)
    {
        // Calculate FFT if a full sample is available.
        if (samplingIsDone())
        {            
            // Run FFT on sample data.
            //arm_cfft_radix2_f32(arm_cfft_radix2_instance_f32*S, samples);
            arm_cfft_f32(S, samples, 0, 1);
            arm_cfft_f32(S, samples2, 0, 1);
            arm_cfft_f32(S, samples3, 0, 1);
           samples[0]=0;
           samples2[0]=0;
           samples3[0]=0;
            
            /* Initialize the CFFT/CIFFT module */
            //arm_cfft_radix2_init_f32(S, 128, 0, 1);
            //arm_cfft_radix2_f32(S, samples);
            //for(int i = 0;i < FFT_SIZE*2;++i)
            //    pc.printf("     Samples[%d]: %8.2f ",i,samples[i]);
            //pc.printf("\r\n");
            // Calculate magnitude of complex numbers output by the FFT.
            arm_cmplx_mag_f32(samples, magnitudes, FFT_SIZE);
            arm_cmplx_mag_f32(samples2, magnitudes2, FFT_SIZE);
            arm_cmplx_mag_f32(samples3, magnitudes3, FFT_SIZE);
            
            //for(int i = 0;i < FFT_SIZE;++i)
            //    pc.printf("     Magnitude: %d = %8.2f ;", i, magnitudes[i]);
            //pc.printf("       \r\n");
            arm_max_f32(magnitudes, FFT_SIZE, &maxValue, &testIndex);
            arm_max_f32(magnitudes2, FFT_SIZE, &maxValue2, &testIndex2);
            arm_max_f32(magnitudes3, FFT_SIZE, &maxValue3, &testIndex3);
            pc.printf("     MAX value at magnitudes 1[%d] : %+8.2f\r\n", testIndex, maxValue);//Я НЯШКА А АНЯ ВЛАСЮК КОЗА:DDDDDDDDDDDDD
            pc.printf("     MAX value at magnitudes 2[%d] : %+8.2f\r\n", testIndex2, maxValue2);
            pc.printf("     MAX value at magnitudes 3[%d] : %+8.2f\r\n", testIndex3, maxValue3);
            
            double delta_t = 0;
            if ((testIndex < testIndex2) and (testIndex < testIndex3) and (testIndex2 < testIndex3))
                delta_t = (testIndex3 - testIndex)*0.000025;
            else if ((testIndex < testIndex2)and(testIndex < testIndex3)and(testIndex2 > testIndex3))
                delta_t = (testIndex2 - testIndex)*0.000025;
            else if ((testIndex2 < testIndex3)and(testIndex2 < testIndex)and(testIndex < testIndex3))
                delta_t = (testIndex3 - testIndex2)*0.000025;
            else if ((testIndex2 < testIndex3)and(testIndex2 < testIndex)and(testIndex > testIndex3))
                delta_t = (testIndex - testIndex3)*0.000025;
            else if (testIndex2 < testIndex)
                delta_t = (testIndex - testIndex3)*0.000025;
            else
                delta_t = (testIndex - testIndex2)*0.000025;
            double fi = asin(330*delta_t/0.33);
            pc.printf("     Angle is  : %+8.2f\r\n", fi);
            
            // Wait for user confirmation to restart audio sampling.
            //pc.getc();
            wait(1);
            samplingBegin();
        }
    }
}

