#include "mbed.h"
#include "TSISensor.h"

// Example program for lab 5
// -------------------------
//  A value is read from the touch sensor and use
//    to control two LEDs
//  The value is also output to the serial interface

Serial pc(USBTX, USBRX); // tx, rx
DigitalOut redLED(LED_RED);
DigitalOut greenLED(LED_GREEN);
DigitalOut blueLED (LED_BLUE);
DigitalOut led1(D0);
TSISensor tsi;

Thread redThread ; // thread for red LED
Thread greenThread ; // thread for green LED
Thread blueThread ;
Thread orangeThread ;
 
void red_thread() {  // method to run in thread
    while (true) {
        Thread::signal_wait(0x1);
        redLED = !redLED ; // turn on 
        redThread.signal_clr(0x1) ;
          // Signal are automatically cleared by wait_signal but
          // the signal might have been set again while LED on 
    }
}

void green_thread() {  // method to run in thread
    while (true) {
        Thread::signal_wait(0x1);
        greenLED = !greenLED ; // turn on 
        greenThread.signal_clr(0x1) ;
          // Signal are automatically cleared by wait_signal but
          // the signal might have been set again while LED on 
    }
}

void blue_thread() {  // method to run in thread
    while (true) {
        Thread::signal_wait(0x1);
        blueLED = !blueLED ; // turn on        
        blueThread.signal_clr(0x1) ;
          // Signal are automatically cleared by wait_signal but
          // the signal might have been set again while LED on 
    }
}

void orange_thread() {  // method to run in thread
    while (true) {
        
        led1 = true;
        Thread::signal_wait(0x1);
        led1 = !led1 ; // turn on 
        orangeThread.signal_clr(0x1) ;
          // Signal are automatically cleared by wait_signal but
          // the signal might have been set again while LED on 
    }
}


int main(void) {
    redLED = true ; // turn off 
    greenLED = true ; // turn off 
    blueLED = true ;
    led1 = true ;
    redThread.start(&red_thread) ; // start the red thread
    greenThread.start(&green_thread) ; // start the green thread
    blueThread.start(&blue_thread) ;
    orangeThread.start(&orange_thread);
    
    while (true) {
        uint8_t d = tsi.readDistance() ;  // Distance is between 0 and 39
                                          // When no touch --> 0
                                          // Left --> low value  Right --> high value
        pc.printf("%d", d) ;  
        pc.putc(' ') ;
        if (d > 3 && d < 9) redThread.signal_set(0x1) ;
        
        if (d > 13 && d < 19) greenThread.signal_set(0x1) ;
        
        if (d > 23 && d < 29) blueThread.signal_set(0x1) ;
        
        if (d > 30 && d < 39) orangeThread.signal_set(0x1) ;
        
        Thread::wait(200);  // This polling rate is too slow - increase it
                            // The slower rate maks it easier to output on the terminal
    }
}
