/*--------------------------------------------------------------------------------------------- 
    Instru_Tarea1
    Tarea 1 de la clase de instrumentación. Lee un sensor de temperatura y lo muestra en un 
    display de 7 segmentos de 4 dígitos con presición de un decimal. Un motor servo se mueve 
    dependiendo de la temperatura (actúa como indicador analógico).
 
    Elementos empleados:
        * (1) Sensor de temperatura y humedad HMZ-433
        * (1) Resistencia de 10 Kohms
        * (1) Display de 7 segmentos de 4 digitos de ánodo común
        * (9) Resistencias de 100 ohms
        * (4) Transistores BC549
        * (1) Motor servo standard
 
    Autores:
        * Sarahí Moran      A00366454
        * Gerardo Carmona   A00940517
 
    Fecha última actualización:
        * 31/Ago/2014
 
    Control de versiones:
        * 23/Ago/2014: Se hizo la programación inicial, terminando la lectura del sensor de 
        temperatura, se pudo desplegar en el display de 7 segmentos la temperastura (solo
        números enteros)
        * 26/Ago/2014: Se pudo desplegar con un decimal de presición, se cambió el tiempo de la
        interrupción a 2.0 segundos.
        * 31/Ago/2014: Se realizarón mejores prácticas de programación, se agregaron los
        comentarios.
---------------------------------------------------------------------------------------------*/
 
//----- Librerias -----------------------------------------------------------------------------
#include "mbed.h"
 
//----- Parametros ----------------------------------------------------------------------------
// tiempo que permanece encendido cada segmento (en seg)
#define TIME_ON 0.005
// Constantes para el termistor
#define AA 0.002301985
#define BB 0.0002758611
#define CC 0.000000416479325577
// Parametros para el display 7 segmentos de 4 digitos
#define TURN_OFF 0xFF
#define N0 64
#define N1 121
#define N2 36
#define N3 48
#define N4 25
#define N5 18
#define N6 2
#define N7 120
#define N8 0
#define N9 24
#define S1 1 
#define S2 2
#define S3 4
#define S4 8
#define LC 70
#define ON 0
#define OFF 1
 
//----- Puertos y objetos --------------------------------------------------------------------- 
DigitalOut on_led(LED_GREEN);
             // A      B      C     D     E     F     G
BusOut display(PTB23, PTA2, PTC2, PTC3, PTB18, PTC4, PTD0);
            //  S1     S2     S3    S4  (de izquierda a derecha) 
BusOut segmento(PTC16, PTC17, PTB9, PTA1);
DigitalOut punto(PTD2);                 // Punto decimal
DigitalOut punto_c(PTD3);               // "°" para °C
AnalogIn tem_pin (A0);
PwmOut PWM1(D13);                       // Salida PWM para mover el servo
Ticker temperatura;                     // Interrupción por tiempo para calcular la temperatura
Ticker servo;                           // Interrupción por tiempo para mover el servo
 
//----- Variables -----------------------------------------------------------------------------
volatile double tem;                    // Variable global para guardar el valor de tem en °C
float t = 0;                       
 
//----- Prototipo funciones -------------------------------------------------------------------
void prende(float num);                 // Funcion para determinar que numeros prender
void prende_segmento(int num, int seg); // Funcion para encender el display
void mover_servo ();                    // Funcion para mover el servo
void calc_tem();                        // Funcion para calcular el nuevo valor de temperatura
 
//----- Programa principal --------------------------------------------------------------------
int main(){
    PWM1.period_ms(20);                 // Periodo de 20 ms
    display = TURN_OFF;                 // Apagar display (anodo comun)
    segmento = 0;                       // Ningun segmento seleccionado
    wait (2);                           // Espera antes de  iniciar
    temperatura.attach(&calc_tem, 2.0); // Actualiza la medicion de temperatura cada 2.0 seg
    servo.attach(&mover_servo, 2.0);    // Actualiza la posicion del servo cada 2.0 seg
 
    while (true) {
        t = tem;
        //printf ("%d\n\r",x);
        prende(t);
           
    }
}
 
//----- Funciones ----------------------------------------------------------------------------- 
void prende(float num){
    float decimal;
    int decenas, unidades;
    
    decenas = num / 10;
    unidades = num - (decenas * 10);
    
    decimal = num - decenas * 10 - unidades;
    decimal = decimal * 10;
 
    prende_segmento(decenas, 1);        // Segmento de decenas con su valor
    prende_segmento(unidades, 2);       // Segmento de unidades
    prende_segmento((int)decimal,3);    // Segmento de decimales
    prende_segmento(10,4);              // Letra C
 
    //printf("cen = %d, dec = %d, uni = %d\n\r", centenas, decenas, unidades);
}
 
void prende_segmento(int num, int seg){
    switch (num){
        case 0: display = N0; break;
        case 1: display = N1; break;
        case 2: display = N2; break;
        case 3: display = N3; break;
        case 4: display = N4; break;
        case 5: display = N5; break;
        case 6: display = N6; break;
        case 7: display = N7; break;
        case 8: display = N8; break;
        case 9: display = N9; break;
    }
   
    switch (seg){
        case 1: 
            segmento = S1; 
            break;
        case 2:
            segmento = S2;
            punto = ON;
            punto_c = ON;               // Apaga el simbolo de °
            break;
        case 3:
            segmento = S3;
            punto = OFF;
            punto_c = OFF;              // Prender el simbolo de °
            break;
        case 4:
            display= LC;                // Desplega la C
            segmento = S4;
            break;
    }
    wait (TIME_ON);                     // Espera un instante
}
 
 
void calc_tem(){
    tem = tem_pin;
    tem = tem * 3.3;
    tem = (4.8*8.81) / tem - 8.81;
    // Utiliza la ecuacion de Steinhart–Hart
    // The Steinhart–Hart equation is a model of the resistance of a semiconductor at 
    // different temperatures
    tem = (1 / (AA + BB * log(tem) + pow(CC * log(tem),3))) - 273.15;
    
    //printf("Tem %f C \n\r", tem);
}   

void mover_servo(){
    int pulso = abs((tem - 29)) * 100 + 1000;
    if (pulso < 1000){
        pulso=1000;
       }
         else if (pulso > 2000){
          pulso=2000;
          }
    PWM1.pulsewidth_us(pulso);
} 