#include "mbed.h"

Serial pc(USBTX, USBRX); // tx, rx
DigitalOut myled(LED2);
DigitalOut led_a(LED3);

#define u1          8
#define M1          1
#define u2          3
#define M2          3
#define u3          15
#define M3          1
#define pQ3Q1       0.1         // probability of sending Q3 output to the Q1 input
#define pQ3Out      0.9        // probability of delivering Q3 output as system output
#define tf          10000
#define lambda      10
#define pQ1I_Q2I    0.5
#define sz_a        1000

int Q1[sz_a]= {0};              // initial Q1
int Q2[sz_a]= {0};              // initial Q2
int Q3[sz_a]= {0};              // initial Q3
float t = 0;               // initial simulation time
float t_events_Q1[sz_a] = {0};     // time stamps for the k events
float t_events_Q2[sz_a] = {0};     // time stamps for the k events
float t_events_Q3[sz_a]= {0};     // time stamps for the k events
int k=1;                 // event number

double SI = 0;

double Q1I1 = tf;
double Q1I2 = 0;
double Q1O = 0;

double Q2I1 = 0;
double Q2O = 0;

double Q3I1 = 0;
double Q3I2 = 0;
double Q3O = tf;


double SO = 0;

float Q1_lambda [sz_a]= {lambda*0.5};
float Q2_lambda [sz_a]= {lambda*0.5};
float Q3_lambda [sz_a]= {1/(u1*M1) + 1/(u2*M2)};

float t_Q1=0;
float t_Q2=0;
float t_Q3=0;

float eventtime_Q1=0;
float eventtime_Q2=0;
float eventtime_Q3=0;
float eventtime=0;

double min_2(double x, double y);
double min_3(double x, double y, double z);
int max_2(int x, int y);
double max_3(double x, double y, double z);
float var_rand(float x);

int Q1k;
int Q2k;
int Q3k;


float x_i=0;
float exprnd=0;
int i=0;
int main()
{
      
    while( t <= tf ){
        myled=0;
    //exprnd(1/freq) simulate an exponential pdf with parameter = average time = 1 / arriving rate    
    
    // System input     
    
    SI = var_rand(lambda); 
    
    
    // Q1
    Q1I1 = Q3O/pQ3Q1;
    Q1I2 = SI/0.5;
    printf("Sl: %lf \n", SI);
    Q1_lambda [k]= (1/Q1I1 + 1/Q1I2);
    
    //printf("Q1I1: %lf \n", Q1I1);
    //printf("Q1I2: %lf \n", Q1I2);
    //printf("Q1_lambda: %f \n", Q1_lambda[k]);
     
    if(Q1[k] > 0){
        Q1O = float(u1)*float (M1);  // service time in the queue
        Q1O= var_rand(Q1O);
    }
    else{
        Q1O= min_2(Q1I1,Q1I2)+1.0;
    }
    //printf("Q1O: %lf \n", Q1O);   
    
    // Update queue Q1 
    t_events_Q1[k]=(t+min_3(Q1I1,Q1I2,Q1O));
    //printf("Q1K :%d \n",Q1[k]);
    if ( (Q1O < Q1I1) && (Q1O < Q1I2) ){
        Q1k=Q1[k]- 1;  
        Q1[k+1]=max_2(0,Q1k); // Q1 is reduced by one
    
    }
    else        {
        Q1[k+1]=Q1[k]+1; // Q1 is increased by one due to Q1 input (only one of the two inputs is considered)
    }
    
    //printf("Q1K :%d \n",Q1[k+1]);
    eventtime_Q1 = min_3(Q1I1, Q1I2, Q1O);
    t_Q1 = t;
    t_Q1 = t_Q1 + eventtime_Q1;
        
    // Q2
    Q2I1 = SI/pQ1I_Q2I;
    //printf("Q2I1 :%lf \n",Q2I1);
    Q2_lambda[k] = (1.0/Q2I1);
    //printf("Q2_lambda :%f \n",Q2_lambda[k]);
    
    if(Q2[k] > 0){
        Q2O = float(u2)*float(M2); // service time in the queue
        Q2O= var_rand(Q2O);
    }
    else{
        Q2O = Q2I1 + 1.0;
    }
    //printf("Q20 :%f \n",Q2O);
    
    // Update queue Q2 
    t_events_Q2[k]=(t+min_2(Q2I1, Q2O));
    //printf("Q2[k]: %d\n",Q2[k]);
    if ( Q2O < Q2I1 ){
        Q2k=Q2[k]- 1;
    //    printf("Q2K %d: \n",Q2k);
        Q2[k+1]=max_2(0,Q2k); // Q2 is reduced by one
    }
    else{
        Q2[k+1]= (Q2[k])+1; // Q2 is increased by one due to Q2 input
    }
    //printf("Q2[k]: %d\n",Q2[k+1]);
    eventtime_Q2 = min_2(Q2I1, Q2O);
    t_Q2 = t;
    t_Q2 = t_Q2 + eventtime_Q2;
    
    
    //Q3
    Q3I1 = Q1O;
    Q3I2 = Q2O;
    //printf("Q3I1: %lf \n",Q3I1);
    //printf("Q3I2: %lf \n",Q3I2);
    Q3_lambda [k]= 1/Q3I1 + 1/Q3I2;
    //printf("Q3_lambda: %f \n",Q3_lambda[k]);
    
    if(Q3[k] > 0){
        Q3O = float(u3)*float(M3); // service time in the queue
        Q3O= var_rand(Q3O);    
    }
    else{
        Q3O = min_2(Q1O, Q2O) + 1.0;
    }
    
    //printf("Q3O: %lf \n",Q3O);
    // Update queue Q3 
    t_events_Q3[k]= t+min_3(Q3I1, Q3I2, Q3O);    
    //printf("Q3[k]: %d \n", Q3[k]);
    if ( (Q3O < Q3I1) && (Q3O < Q3I2) ){
        Q3k=Q3[k]- 1;
    //    printf("Q3k: %f \n", Q3k); 
        Q3[k+1]=max_2(0,Q3k); // Q3 is reduced by one
    }
    else        {
        Q3[k+1]= Q3[k] + 1; // Q3 is increased by one due to Q3 input (only one of the two inputs is considered)

    }
    //printf("Q3[k]: %d \n",Q3[k+1]);
    eventtime_Q3 = min_3(Q3I1, Q3I2, Q3O);
    t_Q3 = t;
    t_Q3 = t_Q3 + eventtime_Q2;
    
    // System output
    SO = Q3O/pQ3Out;
    
    eventtime = max_3(eventtime_Q1, eventtime_Q2, eventtime_Q3);
    t = t + eventtime;
    k=k+1;
    
    myled=1;
    wait(0.5);      
    }          
    
    
    led_a=0;
    wait(1);
    pc.printf("k=");
    pc.printf("%d\r\n",k);
    wait(.5);
    
    pc.printf("Q1\n");
    for (i=0; i<=k; i++){
        pc.printf("%d, ",Q1[i]);
        
        }
    
    pc.printf("\n Q2\n");  
    for (i=0; i<=k; i++){
        pc.printf("%d, ",Q2[i]);
        
        }  
        
    pc.printf("\n Q3\n");  
    for (i=0; i<=k; i++){
        pc.printf("%d, ",Q3[i]);
        
        }  
    
    pc.printf("\n Q1_lambda\n");  
    for (i=0; i<=k; i++){
        pc.printf("%f, ",Q1_lambda[i]);
        
        }  
    
    pc.printf("\n Q2_lambda\n");  
    for (i=0; i<=k; i++){
        pc.printf("%f, ",Q2_lambda[i]);
        
        }  
    pc.printf("\n Q3_lambda\n");    
    for (i=0; i<=k; i++){
        pc.printf("%f, ",Q3_lambda[i]);
        
        }  
    
    pc.printf("\n t_events_Q1\n");    
    for (i=0; i<=k; i++){
        pc.printf("%f, ",t_events_Q1[i]);
        
        }  
    pc.printf("\n t_events_Q2\n");    
    for (i=0; i<=k; i++){
        pc.printf("%f, ",t_events_Q2[i]);
        
        } 
        
    pc.printf("\n t_events_Q3\n");    
    for (i=0; i<=k; i++){
        pc.printf("%f, ",t_events_Q3[i]);
        
        } 
            
    
    led_a=1;
}


//-----------------------Función para obtener el minimo de 2 números ---------------------------------------------//
double min_2(double x, double y){
     double min=0;
     if (x<y){
         min= x;
         }
     else {
        min=y;
        }
        return min;
    
    }
    
///-----------------------Función para obtener el minimo de 3 números ---------------------------------------------//
double min_3(double x, double y, double z){
     double min=0;
     if ((x<y)&&(x<z)){
         min= x;
         }
     else if ((y<x)&&(y<z)){
         min= y;
         }
     else {
         min=z;
         }
         return min;
}

//-----------------------Función para obtener el miáximo de 2 números ---------------------------------------------//
int max_2(int x, int y){
    int max=0;
    if(x>y){
        max=x;
        }     
    else {
        max=y;
        }
        return max;
    }


//-----------------------Función para obtener el máximo de 3 números ---------------------------------------------//
double max_3(double x, double y, double z){
     double max=0;
     if ((x>y)&&(x>z)){
         max= x;
         }
     else if ((y>x)&&(y>z)){
         max= y;
         }
     else {
         max=z;
         }
         return max; 
    }

float var_rand(double x){
    x_i= rand()%100;
    x_i= x_i/float(100);
    //pc.printf("x_i: %f\n",x_i);      
    exprnd=(-1.0)*float(x)*log(x_i);
    return exprnd;
    }