#include "mbed.h"

SPISlave ser_port(D11,D12,D13,D2); // mosi, miso, sclk, ssel
DigitalOut red_led(LED_RED);            //red led
DigitalOut green_led(LED_GREEN);          //green led
DigitalIn  switch_ip1(SW1);
DigitalIn  switch_ip2(SW3);

char switch_word ;                  //word we will send
char recd_val;                      //value received from master

int main() {
  switch_ip1.mode(PullUp);
  switch_ip2.mode(PullUp);
  
  //default formatting applied
  while(1) {
    //set up switch_word from switches that are pressed 
    switch_word=0xa0;             //set up a recognisable output pattern
    if (switch_ip1==0)
      switch_word=switch_word|0x01;
    if (switch_ip2==0)
      switch_word=switch_word|0x02;
    
    if(ser_port.receive()) {      //test if data transfer has occurred
      recd_val = ser_port.read();   // Read byte from master
      ser_port.reply(switch_word);  // Make this the next reply
    } 
    //set leds according to incoming word from slave
    red_led=1;              //preset both to 0
    green_led=1; 
    recd_val=recd_val&0x03; //AND out unwanted bits
    if (recd_val==1)
      red_led=0;
    if (recd_val==2)
      green_led=0;
    if (recd_val==3){
      red_led=0;
      green_led=0;
    }
  }    
} 
    //now set leds according to received word