#include "mbed.h"


I2CSlave slave(A5,A4);  //Configure I2C slave

DigitalOut red_led(LED_RED);     //red led
DigitalOut green_led(LED_GREEN);   //green led
DigitalIn  switch_ip1(SW2);
DigitalIn  switch_ip2(SW3);

char switch_word ;    //word we will send
char recd_val;        //value received from master

int main() {

  slave.address(0x52);
    while (1) {
      //set up switch_word from switches that are pressed 
      switch_word=0xa0;          //set up a recognisable output pattern
       if (switch_ip1==0)
        switch_word=switch_word|0x01;
      if (switch_ip2==0)
        switch_word=switch_word|0x02;
      slave.write(switch_word); //load up word to send
      
      //test for I2C, and act accordingly
      int i = slave.receive();
      printf ("%d\n\r" ,i);
      if (i == 3)              //slave is addressed, Master will write
        recd_val= slave.read();
      //now set leds according to received word
      red_led=1;
      green_led=1;
      recd_val=recd_val&0x03;
          if (recd_val==1)
        red_led=0;
      if (recd_val==2)
        green_led=0;
      if (recd_val==3){
        red_led=0;
        green_led=0;
      }
   }            //end of while
}          //end of main
