#include "mbed.h"
  
 
DigitalOut on_led(LED_RED);
BusOut display(PTB18, PTB19, PTC1, PTC8, PTC9, PTC0, PTC7);
//BusOut display(PTC5, PTC7, PTC0, PTC9, PTC8, PTC1, PTB19, PTB18);
BusOut segmento( PTC16, PTC17, PTB9, PTA1);
DigitalOut punto(PTC5);
DigitalOut punto_c(PTB23);
double calc_tem ();
AnalogIn tem_pin (A0);
 
 
int c = 0;
 
void prende(int num);
void prende_segmento(int num, int seg);
 
int main(){
 display =0xFF;
 segmento = 0;
 punto= 1;
 wait (2);
 punto_c= 1;
 
    while (true) {
        double t= calc_tem();
        int x= t;
        printf ("%d\n\r",x);
        prende(x);
   
    }
}
 
void prende(int num){
    int centenas, decenas, unidades;
    
    centenas = num / 100;
    decenas = (num - (centenas * 100 )) / 10;
    unidades = num - (centenas * 100 ) - (decenas * 10);
    
    if (centenas != 0){
        prende_segmento(centenas, 1);
    }else{
        prende_segmento(0, 1);
    }
    
    if (decenas != 0){
        prende_segmento(decenas, 2);
    }else{
        prende_segmento(0, 2);
    }
    
    if (centenas != 0){
        prende_segmento(unidades, 3);
    }else{
        prende_segmento(0, 3);
    }
    prende_segmento(10,4);
 
}
 
void prende_segmento(int num, int seg){
    
    switch (num){
        case 0:
            display = 64;
            break;
        case 1:
            display = 121;
            break;
        case 2:
            display = 36;
            break;
        case 3:
            display = 48;
            break;
        case 4:
            display = 25;
            break;
        case 5:
            display = 18;
            break;
        case 6:
            display = 2;
            break;
        case 7:
            display = 120;
            break;
        case 8:
            display = 0;
            break;
        case 9:
            display = 24;
            break;
        default:
            display = 0xFF ;
    }
   
    switch (seg){
        case 1:
            segmento = 1;
            wait (0.001);
            break;
        case 2:
            segmento = 2;
            punto= 0;
            wait (0.001);
            break;
        case 3:
            segmento = 4;
            punto=1;
            wait (0.001);
            break;
        case 4:
            display= 70;
            segmento = 8;
            wait (0.001);
            break;
        default:
            segmento = 0;
            wait (0.001);
    }
    }
double calc_tem(){
double tem;
tem = tem_pin;
tem = tem * 3.3;
tem = (4.8*8.81) / tem - 8.81;

printf("tem %f\n\r", tem);

tem = (1 / (0.002301985 + 0.0002758611* log(tem) + pow(0.000000416479325577 * log(tem),3))) - 273.15;



return tem; 
}   

        
