/*
ESTE PROGRAMA PERMITE CONFIGURAR EL SIGUMINETO DE UNA CONSIGNA A TRAVES DE CONTROLADOR PID,PARA UN HORNO DE REFLUJO
SE USA LA SALIDA ANALOGA Y PWM DE LA TARJETA, SEGUN SE DESEE.
ESTA TAREA FUE DESARROLLADA POR SANTIAGO GOMEZ ESTRADA,JUAN FERNANDO ZAPATA Y MATEO
PARA LA MATERIA DE PROCESADORES DE LA UNIVERSIDAD NACIONAL DE COLOMBIA SEDE MEDELLÍN, PRIMER SEMESTRE DEL AÑO 2018
*/
#include "mbed.h"
#include "DebouncedIn.h"
#include "TextLCD.h"
#include "QEI.h"
#include "Rtc_Ds1307.h"
#include "string.h"

Serial pc(USBTX, USBRX);

TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7
Rtc_Ds1307 rtc(PTE0, PTE1);
QEI wheel (PTA16, PTA17, NC, 48);
DebouncedIn button_enco(PTC5);
DigitalOut myled(LED3);
AnalogIn y(PTB3);//entrada analoga
AnalogOut u(PTE30);//salida analoga OJO solo se le pueden drenar 1.5mA en circuitos use un Buffer
PwmOut Upwm(PTE29);

int dato; // tiempo de cada dato que se lee
int pul_low;

char r;


int mode=0;
int code;


//
int C1=0x0C;
int m;
int Conf=0;  // 0: Alarma y 1:Reloj
int Lugar=0; // Definen el punto en el cual va el programa
int i=0;
int j=1;
float periodo;
float Frecuencia = 2000; 
int cont=0;
int visual=0;
int alarma=0;
float pid,o,ai,ad,ap,med,err;
float err_v;
int sp=0,Ki=0,Kp=0,Kd=0,pos=1;
int t1=0,t2=0,t3=0,T1=0,T2=0,T3=0;

int main()
{
    myled=1;
    j=1;
    Rtc_Ds1307::Time_rtc tm2 = {};
    
    
    lcd.cls();
    lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD
    lcd.locate(0,0);
    lcd.printf("--Control --Consig"); 
    
    periodo=(1/Frecuencia);
    Upwm.period(periodo);
    Upwm.pulsewidth(0);
    
    
    while(1)
    {
        
        switch (Lugar)
        {
            case 0:
                m=wheel.getPulses();  // m son los datos del encoder
                if(m!=0 && Conf==0){
                    Conf=1;
                    wheel.reset();  
                    m=0;              
                }
                
                if(m!=0 && Conf==1){
                    Conf=0;
                    wheel.reset();  
                    m=0;              
                }
                
                if(Conf==0){
                    
                    lcd.locate(11,0);
                    lcd.printf("-");                    
                    lcd.locate(1,0);
                    lcd.printf(">");
                    lcd.locate(0,1);                    
                    wait(0.1);
                    
                }
                
                 if(Conf==1){
                    
                    lcd.locate(1,0);
                    lcd.printf("-");                    
                    lcd.locate(11,0);
                    lcd.printf(">");
                    lcd.locate(0,1);                    
                    wait(0.1);
                }
                
                if (button_enco.falling()){  //si se pulsa boton encoder
                    Lugar++;
                    m=0;       
                }
            
            break;
            
            case 1:
                switch(i)
                {
                    case 0:                     
                        if(Conf==0) // control
                        {
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Config. Control ");
                            wait(1);
                            lcd.cls();
                            i++;
                            lcd.locate(0,0);
                            lcd.printf("Kp: ");
                            m=0;                             
                        }
                
                        if(Conf==1) //consignas
                        {
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Config.consig   ");
                            wait(1);
                            i=5;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("t1: ");
                            m=0;
                            
                        }    

                    break;
                    
                    case 1: //Kp
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            Kp=Kp+m;
                            
                        
                            
                            wheel.reset();  
                            m=0;
                        }
                        
                        lcd.locate(5,0);
                        lcd.printf("%d   ",Kp);
                        
                        
                        
                        if (button_enco.falling())
                        {
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Ki: ");
                        }
                    
                    break;
                    case 2: // Ki
                        m=0;
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            Ki=Ki+m;
                            
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(5,0);
                        lcd.printf("%d   ",Ki);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Kd: ");
                            
                        }
                    break;
                    case 3: // Kd
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            Kd=Kd+m;
                            
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(7,0);
                        lcd.printf("%d",Kd);
                        
                        if (button_enco.falling())
                        {
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("sp: ");
                            
                        }
                    
                    break;
                    
                    case 4: //set point
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            sp=sp+m;
                            
                            
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(6,0);
                        lcd.printf("%d",sp);
                        
                        if (button_enco.falling())
                        {
                            
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Control config. ");
                            wait(1);
                            i=0;
                            m=0;
                            Lugar=0;
                            lcd.locate(0,0);
                            lcd.printf("--Control --Consig");   
                            
                        }
                    
                    break;
                    
                    
                    
                    
                    
                    
                    case 5: //t1
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            t1=t1+m;
                            
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(8,0);
                        lcd.printf("%d",t1);
                        
                        if (button_enco.falling())
                        {
                            ///////////////////
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("t2: ");
                           
                           ///////////////////
                        }
                    
                    break;
                    case 6: //t2
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            t2=t2+m;
                            
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(8,0);
                        lcd.printf("%d",t2);
                        
                        if (button_enco.falling())
                        {
                            ///////////////////
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("t3: ");
                           
                           ///////////////////
                        }
                    
                    break;
                    case 7: //t3
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            t3=t3+m;
                            
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(8,0);
                        lcd.printf("%d",t3);
                        
                        if (button_enco.falling())
                        {
                            ///////////////////
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("T1: ");
                           
                           ///////////////////
                        }
                    
                    break;
                    case 8: //T1
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            T1=T1+m;
                            
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(8,0);
                        lcd.printf("%d",T1);
                        
                        if (button_enco.falling())
                        {
                            ///////////////////
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("T2: ");
                           
                           ///////////////////
                        }
                    
                    break;
                    case 9: //t2
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            T2=T2+m;
                            
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(8,0);
                        lcd.printf("%d",T2);
                        
                        if (button_enco.falling())
                        {
                            ///////////////////
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("T3: ");
                           
                           ///////////////////
                        }
                    
                    break;
                    case 10: //T3
                        m=wheel.getPulses();        
                        if (m!=0) 
                        {
                            T3=T3+m;
                            
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(8,0);
                        lcd.printf("%d",T3);
                        
                        if (button_enco.falling())
                        {
                            ///////////////////
                            Lugar++;
                            m=0;
                            lcd.cls();
                            
                           
                           ///////////////////
                        }
                    
                    break;
                   
                }            
            break;
            
            case 2: // MOSTRAR EL TIEMPO Y LA ALARMA, Y COMPROBAMOS ESTADO DE LA ALARMA
                rtc.getTime(tm2); //LECTURA RTC
                if(cont==0)
                {    tm2.min=0;
                     tm2.sec=0;
                     cont++;
                     rtc.setTime(tm2, false, false);
                     rtc.startClock();
                
                
                }       
                if(visual==0)
                {    
                    lcd.locate(0,0);                        
                    lcd.printf("tiempo: ");
                    lcd.locate(8,0);    
                    
                    lcd.printf("%02d:",tm2.min);
                    lcd.printf("%02d",tm2.sec); 
                    lcd.locate(0,1);
                    lcd.printf("%d",sp); 
                    
                    
                    wait(0.1);
                    //////////
                    
                }
                med = y.read()*999;
                err = (sp-med);  //se calcula el error
                ap = Kp*err*0.01f;     //se calcula la accion proporcinal
                ai =(Ki*err*0.01f)+ai;    //calculo de la integral del error
                ad = Kd*(err-err_v)*0.01f; //calculo de la accion derivativa
                pid = (ap+ai+ad);
        // se verifica que pid sea positivo **************************************
                if(pid<=0)
                {
                pid=0;
                }
 
        // se verifica que pid sea menor o igual la valor maximo *****************
                if (pid > 999)
        {
                pid=999;
        }
 
       
        //se muestran las variables******************************************
                
                lcd.locate(4,1);
                lcd.printf("%3.0f",err);
                
                lcd.locate(11,1);
                lcd.printf("%3.0f",pid);
           
            
        
 
        //Normalizacion de la salida
        // se actualizan las variables *******************************************
                err_v = err;
                o = pid/999;
                u.write(o);
        //  se envia el valor pid a puerto analogico de salida (D/A) **************
                Upwm.pulsewidth(o*periodo);//salida pwm
        //  se repite el ciclo
                wait_ms(300);
                
                
                
                 
            break;
            
            
        }
        
    }          
}