// RF22_REG_05_INTERRUPT_ENABLE1                0x05
#define RF22_ENFFERR                            0x80
#define RF22_ENTXFFAFULL                        0x40
#define RF22_ENTXFFAEM                          0x20
#define RF22_ENRXFFAFULL                        0x10
#define RF22_ENEXT                              0x08
#define RF22_ENPKSENT                           0x04
#define RF22_ENPKVALID                          0x02
#define RF22_ENCRCERROR                         0x01

// RF22_REG_06_INTERRUPT_ENABLE2                0x06
#define RF22_ENSWDET                            0x80
#define RF22_ENPREAVAL                          0x40
#define RF22_ENPREAINVAL                        0x20
#define RF22_ENRSSI                             0x10
#define RF22_ENWUT                              0x08
#define RF22_ENLBDI                             0x04
#define RF22_ENCHIPRDY                          0x02
#define RF22_ENPOR                              0x01

unsigned char SPI_read(unsigned char address)
{
    nSEL=0;
    spi.write(address & 0x7f); // Send the address with the write mask off
    unsigned char val = spi.write(0); // The written value is ignored, reg value is read
    nSEL = 1;
    return val;
}
void SPI_write(unsigned char address, unsigned char val)
{
    nSEL = 0;
    spi.write(address | 0x80); // Send the address with the write mask on
    spi.write(val); // New value follows
    nSEL = 1;
}
void resetFifos()
{
    SPI_write(0x08, 0x02);
    SPI_write(0x08, 0);
}
char is_trasnfer = 0;
void rf_interrupt_function()
{
    led = !led;
    is_trasnfer = 1;
    pc.printf("data = %d",SPI_read(0x7f));
    pc.printf("s = %d",SPI_read(0x3f));
    resetFifos();
    SPI_read(0x03);
    SPI_read(0x04);    
    SPI_write(0x05, RF22_ENTXFFAEM | RF22_ENRXFFAFULL | RF22_ENPKSENT | RF22_ENPKVALID | RF22_ENCRCERROR | RF22_ENFFERR);

     /*if(ch&0x80)// bit interrupt status
    {
        resetFifos();
        SPI_write(0x07, 9);
    }*/
}

void setFrequency(float centre)
{
    unsigned char fbsel = 0x40;
    if (centre >= 480.0)
    {
        centre /= 2;
        fbsel |= 0x20;
    }
    centre /= 10.0;
    float integerPart = floor(centre);
    float fractionalPart = centre - integerPart;

    uint8_t fb = (uint8_t)integerPart - 24; // Range 0 to 23
    fbsel |= fb;
    uint16_t fc = fractionalPart * 64000;
    SPI_write(0x75, fbsel);
    SPI_write(0x76, fc >> 8);
    SPI_write(0x77, fc & 0xff);
}
bool RFM_init()
{
    wait_ms(16);
    nSEL = 1;
    wait_ms(100);
    spi.format(8,0);
    spi.frequency(10000000);
    SPI_write(0x07, 0x80);// reset chip
    wait_ms(1);
    unsigned char _device_type = SPI_read(0x00);// read RF module mode RX or TX
    if((_device_type != 0x07)&&(_device_type != 0x08))
    {
        return false;
    }
  //  rf_interrupt.fall(&rf_interrupt_function);
    
    SPI_write(0x12, 0x00);
    // no temperature sensor used
    SPI_write(0x13, 0x00);
    // no mancheset code, no data whiting, data rate < 30Kbps
    SPI_write(0x70, 0x20);
    // IF filter bandwidth
    SPI_write(0x1c, 0x04);
    // AFC LOOP
    SPI_write(0x1d, 0x40);
    // AFC timing
    SPI_write(0x1e, 0x08);
    // clock recovery
    SPI_write(0x20, 0x41);
    // clock recovery
    SPI_write(0x21, 0x60);
    // clock recovery
    SPI_write(0x22, 0x27);
    // clock recovery
    SPI_write(0x23, 0x52);
    // clock recovery timing
    SPI_write(0x24, 0x00);
    // clock recovery timing
    SPI_write(0x25, 0x06);
    // Tx data rate 1
    SPI_write(0x6e, 0x27);
    // Tx data rate 0
    SPI_write(0x6f, 0x52);
    SPI_write(0x30, 0x8C);// access data control
    SPI_write(0x32, 0xff);// head control
    SPI_write(0x33, 0x42); // header 3, 2, 1,0 used for head length, fixed packet length, synchronize word length 3, 2,
    SPI_write(0x34, 64);// preamable
    SPI_write(0x35, 0x20);// preamable
    SPI_write(0x36, 0x2d);
    SPI_write(0x37, 0xd4);
    SPI_write(0x38, 0x00);
    SPI_write(0x39, 0x00);
    // set tx header
    SPI_write(0x3a, 's');
    SPI_write(0x3b, 'a');
    SPI_write(0x3c, 'n');
    SPI_write(0x3d, 'g');
    // total tx 17 byte
    SPI_write(0x3e, 1);
    // set rx header
    SPI_write(0x3f, 's');
    SPI_write(0x40, 'o');
    SPI_write(0x41, 'n');
    SPI_write(0x42, 'g');
    
        // all the bit to be checked
    SPI_write(0x43, 0xff);
    // all the bit to be checked
    SPI_write(0x44, 0xff);
    // all the bit to be checked
    SPI_write(0x45, 0xff);
    // all the bit to be checked
    SPI_write(0x46, 0xff);
    // no frequency hopping
    SPI_write(0x79, 0x0);
    // no frequency hopping
    SPI_write(0x7a, 0x0);
    // Gfsk, fd[8]=0, no invert for Tx/Rx data, fifo mode, txclk -->gpio
    SPI_write(0x71, 0x22);
    // frequency deviation setting to 45k = 72*625
    SPI_write(0x72, 0x48);
    // no frequency offset
    SPI_write(0x73, 0x0);
    // no frequency offset
    SPI_write(0x74, 0x0);
    SPI_write (0x0B, 0x12) ; // TX state
    SPI_write (0x0C, 0x15) ; // RX state
    // Enable interrupts
    SPI_write(0x05, RF22_ENTXFFAEM | RF22_ENRXFFAFULL | RF22_ENPKSENT | RF22_ENPKVALID | RF22_ENCRCERROR | RF22_ENFFERR);
    SPI_write(0x06, RF22_ENPREAVAL);
    setFrequency(434.0);
    SPI_write(0x6d, 0x03);// TX power
    SPI_write(0x08, 0x03);
    SPI_write(0x08, 0x00);
    return true;
 }
 
