#ifndef    FONT_H



//#define    TEST
//#define    SMALL_TEST


/***************************************************************************/

extern const unsigned char c14_data_table[];
extern const unsigned int  c14_offset_table[];
extern const unsigned char c14_index_table[];
extern const unsigned char c14_width_table[];

extern const unsigned char c28_data_table[];
extern const unsigned int  c28_offset_table[];
extern const unsigned char c28_index_table[];
extern const unsigned char c28_width_table[];

extern const unsigned char c72_data_table[];
extern const unsigned int  c72_offset_table[];
extern const unsigned char c72_index_table[];
extern const unsigned char c72_width_table[];

extern const unsigned char c78_1_data_table[];
extern const unsigned int  c78_1_offset_table[];
extern const unsigned char c78_1_index_table[];
extern const unsigned char c78_1_width_table[];

typedef struct _font    {
                            int                    dummy0;
                            int                    dummy1;
                            int                    dummy2;
                            int                    height;
                            int                    max_width;
                            int                    space_width;
                            const unsigned char *data_table;
                            const unsigned int    *offset_table;
                            const unsigned char *index_table;
                            const unsigned char *width_table;
                        }
                        font;


extern font         Calibri14;
extern font            Calibri28;
extern font            Calibri72;
extern font            Calibri78_1;


#ifdef TEST
    #ifdef SMALL_TEST
        #define    SC_WIDTH    128
        #define    SC_HEIGHT   128
    #else
        #define    SC_WIDTH    640
        #define    SC_HEIGHT    480
    #endif
#endif

void FontDrawInit( void );

/**    FontDraw_printf
 *        
 *        A "printf" function that takes coodinate values as starting point of the string. 
 *      The coodinate is a point if the left-bottom point of string output area.
 *
 *        Drawing parameters should be set by FontDraw_Set... functions before this function call.
 *      
 *        param: x left position of the string
 *        param: y bottom position of the string
 *      param: format... followings are normal printf arguments
 */
void FontDraw_printf( int x, int y, char *format, ... );


/**    FontDraw_puts
 *        
 *        Similar to "printf" but no format support. It just put a strin on to the screen. 
 *        This may be bit faster than "FontDraw_printf". 
 *
 *        Drawing parameters should be set by FontDraw_Set... functions before this function call.
 *      
 *        param: x left position of the string
 *        param: y bottom position of the string
 *      param: s string
 */
void FontDraw_puts( int x, int y, char *s );


/**    FontDrawString
 *        
 *        Similar to "FontDraw_puts" but this function takes several parameters to define its propaty. 
 *        This function will be useful if user want to use other parameter setting temporary. 
 *      
 *      param: s string
 *        param: x left position of the string
 *        param: y bottom position of the string
 *        param: f_color color value for string itself
 *        param: b_color color value for rectangle around the string
 *        param: font_ptr pointer to the font
 */
void FontDrawString( char *s, int xpos, int ypos, int f_color, int b_color, font *font_ptr );


/**    FontDrawChar
 *        
 *        Similar to "FontDraw_puts" but this function takes several parameters to define its propaty. 
 *        This function will be useful if user want to use other parameter setting temporary. 
 *      
 *      param: c character
 *        param: x left position of the string
 *        param: y bottom position of the string
 *        param: f_color color value for character itself
 *        param: b_color color value for rectangle around the character
 *        param: font_ptr pointer to the font
 *        return: the width of the character (including inter-caracter space if user set)
 */
int FontDrawChar( char c, int xpos, int ypos, int f_color, int b_color, font *font_ptr );

/**    FontDrawStringWidth
 *        
 *        Returns the string width (span) which will be drawn on the screen. 
 *        This will be useful like case of aligning the string at center or right. 
 *        for instance, if the string needed to be aligned to right and of the screen (ex. pixel=480), the code will be...
 *
 *        code: 
 *            x    = 480 - FontDrawStringWidth( "sample string", &Calibri14 );
 *            FontDrawString( "sample string", x, y, 0x000000, 0xFFFFFF, &Calibri14 );
 *      
 *      param: s string
 *        param: font_ptr pointer to the font
 *        return: string width (including inter-caracter space if user set)
 */
int FontDrawStringWidth( char *s, font *font_ptr );


/**    FontDraw_SetFont
 *        
 *        Setting the font to draw
 *        This will affect to following "FontDraw_printf" and "FontDraw_puts" calls
 *      
 *        param: f font  (default: Carlibri14)
 */
void FontDraw_SetFont( font f );


/**    FontDraw_SetInterCharSpace
 *        
 *        Setting the inter-character space
 *        When drawing the string, each caracters can have additional space between those (this will not applied to space caracters)
 *      
 *        param: space pixels. no ngative number can be specified (default: 0)
 */
void FontDraw_SetInterCharSpace( int space );


/**    FontDraw_SetAlphaMode
 *        
 *        If the alphamode is enabled,no background will be written. No rectangle around the charators are drawn.
 *      
 *        param: mode zero for disable, non-zero for enable (default: disable)
 */
void FontDraw_SetAlphaMode( int mode );


/**    FontDraw_SetForegroundColor
 *        
 *        Settng of the color for character itself.
 *      
 *        param: v color (24 bit value) (default: 0x0000FF)
 */
void FontDraw_SetForegroundColor( int v );


/**    FontDraw_SetBackgroundColor
 *        
 *        Settng of the color for rectangle around the charators.
 *      
 *        param: v color (24 bit value) (default: 0xFFFFFF)
 */
void FontDraw_SetBackgroundColor( int v );


#endif