//--------------------------------------------------------------
//  フィルタ処理付き SD オーディオプレーヤーで使う大域関数（ヘッダ）
//
//  2016/07/04, Copyright (c) 2016 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef F746_MY_FUNCTIONS_HPP
#define F746_MY_FUNCTIONS_HPP

#include "SAI_InOut.hpp"
#include "ButtonGroup.hpp"
#include "FileSelectorWav.hpp"
#include "DesignerDrawer.hpp"
#include "SD_WavReader.hpp"

using namespace Mikami;

// １フレーム分の信号処理 (IIR フィルタ) の実行
void IIR_Filtering(SD_WavReader &sdReader, SaiIO &mySai,
                   float g0, Biquad hn[],
                   int order, bool filterOn);

// SD カードのファイルのオープン
int32_t SD_Open(SD_WavReader &sdReader,
             string fileName, int32_t frameSize);

// ファイルの選択
void SelectFile(ButtonGroup &menu, FileSelector &selector,
                Label &msg, string &selectedName);

// フィルタの変更
void ModifyFilter(DesignerDrawer &drawerObj,
                  ButtonGroup &lpHp, ButtonGroup &onOff,
                  Biquad hn[], Biquad::Coefs ck[],
                  float &g0, bool &filterOn);

#endif  // F746_MY_FUNCTIONS_HPP
