//------------------------------------------------------
//  Touch panel detector for x axis class
//
//  2016/03/31, Copyright (c) 2016 MIKAMI, Naoki
//------------------------------------------------------

#ifndef F746_TOUCH_PANELDETECTORX_HPP
#define F746_TOUCH_PANELDETECTORX_HPP

#include "GuiBase.hpp"

namespace Mikami
{
    class TouchPanelDetectorX : public GuiBase
    {
    public:
        // Constructor
        TouchPanelDetectorX(uint16_t x1, uint16_t x2,
                            uint16_t y1, uint16_t y2)
            : X1_(x1), X2_(x2), Y1_(y1), Y2_(y2) {}

        bool IsTouched(uint16_t xIn, uint16_t &xOut)
        {
            GetTsState();
            
            if (!state_.touchDetected) return false;
            
            uint16_t x = state_.touchX[0];
            uint16_t y = state_.touchY[0];

            if ( (x < X1_) || (x > X2_) || (y < Y1_) || (y > Y2_) )
                return false;

            const int WD = 8;
            if ( (x < xIn-WD) || (x > xIn+WD) ) return false;
            
            xOut = (x >= X1_) ? x : X1_;
            xOut = (x <= X2_) ? x : X2_;
            return true;
        }

    private:
        const uint16_t X1_, X2_, Y1_, Y2_;
    };
}   
#endif  // F746_TOUCH_PANELDETECTORX_HPP
