#include "mbed.h"
#include "USBHostKeyboard.h"
#include "SDFileSystem.h"

DigitalOut led(LED1);
SDFileSystem sd(p5, p6, p7, p8, "sd");
int i=0;

void onKey(uint8_t key) {
    printf("Key: 0x%x : %c\r\n", key, key);

    ++i;
    FILE *fp;
    fp = fopen("/sd/keylog/keylog.csv", "a");
    fprintf(fp, "Keydata[%d], :,0x%x,:,%c\r\n", i, key, key);
    fclose(fp); 

}

void keyboard_task(void const *) {
    
    USBHostKeyboard keyboard;
    
    while(1) {
        // try to connect a USB keyboard
        while(!keyboard.connect())
            Thread::wait(500);
    
        // when connected, attach handler called on keyboard event
        keyboard.attach(onKey);
        
        // wait until the keyboard is disconnected
        while(keyboard.connected())
            Thread::wait(500);
    }
}

int main() {
    mkdir("/sd/keylog", 0777);
    FILE *fp;
    fp = fopen("/sd/keylog/keylog.csv","w");
    fclose(fp);
    
    Thread keyboardTask(keyboard_task, NULL, osPriorityNormal, 256 * 4);
    while(1) {
        led=!led;
        Thread::wait(500);
    }
}
