/*******************************************************************************
 * Copyright (c) 2014 IBM Corp.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *
 * The Eclipse Public License is available at
 *    http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 *   http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *    Ian Craggs - initial implementation
 *    Sam Grove  - added mehtod to check the status of the Ethernet cable
 *******************************************************************************/

#if !defined(LPC1768_H)
#define LPC1768_H

#if defined(TARGET_ARCH_PRO) // Seeed Studio Arch Pro

C12832 lcd(D11, D13, D12, D7, D10);
DigitalOut led2(LED2);
PwmOut r(D5);
PwmOut g(P2_0);
PwmOut b(P2_1);
MMA7660 MMA(D14, D15);
LM75B sensor(D14, D15);
DigitalIn Down(A3);
DigitalIn Left(A4);
DigitalIn Click(D4);
DigitalIn Up(A2);
DigitalIn Right(A5);
AnalogIn ain1(A0);
AnalogIn ain2(A1);

#define LED2_OFF 1
#define LED2_ON 0

#else

C12832 lcd(p5, p7, p6, p8, p11);
DigitalOut led2(LED2);
PwmOut r(p23);
PwmOut g(p24);
PwmOut b(p25);
MMA7660 MMA(p28, p27);
LM75B sensor(p28, p27);
DigitalIn Down(p12);
DigitalIn Left(p13);
DigitalIn Click(p14);
DigitalIn Up(p15);
DigitalIn Right(p16);
AnalogIn ain1(p19);
AnalogIn ain2(p20);

#define LED2_OFF 0
#define LED2_ON 1

#endif


#define DEFAULT_TYPE_NAME "iotsample-mbed-lpc1768"

// need a wrapper since K64F and LPC1768 wont have the same name for mii read methods
static uint32_t linkStatus(void)
{
    return 1;
}

#endif