#include "mbed.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"
#include"L3GD20H.h"
#define GYR_ADDRESS 0xD6 // Permet de définir l'adresse du capteur

LCD_DISCO_F746NG lcd;   //Initialisation du LCD
TS_DISCO_F746NG ts;

L3GD20H gyro(PB_9, PB_8); // Permet de Définir où est branché le capteur 

int main()
{
    TS_StateTypeDef TS_State;
    ts.Init(420, 272);
    //  uint32_t pY= 272.0, pX=480.0; //nombre de pixel sur notre écran

    //Interface d'initilisation
    int circle_X = 234; // position d'init du cercle en X
    int circle_Y = 159; // position d'init du cercle en Y
    short g[3]; // Variable ou sera stocké les valeurs mesurées par le capteur
    bool tampon = false;
    int i;
    lcd.Clear(LCD_COLOR_BLUE);
    lcd.SetBackColor(LCD_COLOR_BLUE);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.DisplayStringAt(0, LINE(4), (uint8_t *)"INTERFACAGE POUR L3GD20H", CENTER_MODE); // Initialisation
    lcd.SetFont(&Font16);
    lcd.DisplayStringAt(0, LINE(8), (uint8_t *)"Cree par", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(9), (uint8_t *)"Flipo Samuel", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(10), (uint8_t *)"Bully Jerome", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(11), (uint8_t *)"Barrocas Miguel", CENTER_MODE);
    wait(2);
    //Interface définitive
    lcd.Clear(LCD_COLOR_WHITE); //Couleur d'arrière plan
    lcd.SetFont(&Font24); //Taille de police @24
    lcd.SetBackColor(LCD_COLOR_WHITE); //Fond d'écran du texte en bleu
    lcd.SetTextColor(LCD_COLOR_BLUE); //Texte en blanc
    lcd.DisplayStringAt(0,LINE(0),(uint8_t *)"GYROSCOPE L3GD20H", CENTER_MODE); // TITRE
    lcd.SetFont(&Font12); // Taille de police @12
    lcd.DisplayStringAt(0,236,(uint8_t *)"Flipo Samuel", LEFT_MODE); //Auteur 1
    lcd.DisplayStringAt(0,248,(uint8_t *)"Bully Jerome", LEFT_MODE); //Auteur 2
    lcd.DisplayStringAt(0,260,(uint8_t *)"Barrocas Miguel", LEFT_MODE); //Auteur 3
    lcd.SetFont(&Font16); // Taille de police @16
    while (1) {
        ts.GetState(&TS_State);
        gyro.read(g); //acquisition des données du gyroscope
        /*sprintf(tmp, "%5d %5d %5d" , g[0], g[1],g[2]); //%hd uint16_t
        lcd.SetTextColor(LCD_COLOR_BLUE);
        lcd.DisplayStringAt(0, LINE(2),(uint8_t *)tmp,CENTER_MODE); // Affichage des valeurs*/ //utilité d'afficher les valeurs??

        //------------------------------GESTION DE LA BOULE----------------------------------\\
        //affichage de la zone de déplacement
        BSP_LCD_DrawRect(5,40,460,190); //XPOS , YPOS, TAILLE X, TAILLE Y
        for (i=0; i<=3; i++) {
            g[i]=g[i]/1000; //"mise à l'échelle" data/pixel
        }
        lcd.SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_FillCircle(circle_X,circle_Y,10); //effacement de l'ancien cercle
        circle_X=circle_X+g[0];//déplacement sur l'axe X
        circle_Y=circle_Y+g[2];//déplacement sur l'axe Y
        if (circle_X <15) {
            circle_X=15;   //limite vers la gauche
        }
        if (circle_X >450) {
            circle_X=450;   //limite vers la droite
        }
        if (circle_Y <50) {
            circle_Y=50;   //limite vers le haut
        }
        if (circle_Y >220) {
            circle_Y=220;   //limite vers le bas
        }
        if (TS_State.touchDetected) { //ecran touché
            tampon =not(tampon); //inversion de la variable tampon;
            do {//Blocaque pour effectuer une seule inversion
                ts.GetState(&TS_State);  //récup du TS
            } while(TS_State.touchDetected !=0);
        } //fin Touch Screen
        if (tampon ==false) {
            lcd.SetTextColor(LCD_COLOR_RED);   //boule en couleur rouge
        } else if (tampon ==true) {
            lcd.SetTextColor(LCD_COLOR_WHITE);   //boule en blanc

        }
        BSP_LCD_FillCircle(circle_X,circle_Y,10); //écriture de la boule rouge
        wait(0.01); //attente pour le calcul
        
    } //fin while
}//fin main