#include "mbed.h"
#include "GPS.h"
#include "rtos.h"
#include "MODSERIAL.h"
#include <string>
#include <iostream>

using namespace std;

const string GoogleChunk = "https://maps.google.com.au/maps?q=";
const string GoogleExtras = "&z=20";
char GPRSbuffer[512];
string dump;
int index;
int i = 0;

GPS gps(p9,p10);
MODSERIAL GPRS(p13,p14);                                      // MODSERIAL for rxBufferFlush()
MODSERIAL pc(USBTX,USBRX);

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

void led_thread(void const *argument)                         // Some light jazz in a thread
{
    while (true) {
        DigitalOut leds[4] = {myled1, myled2, myled3, myled4};
        int pattern[6][4] = {{1,0,0,0},{0,1,0,0},{0,0,1,0},{0,0,0,1},{0,0,1,0},{0,1,0,0}};
        int i=0;
        while(1) {
            leds[0] = pattern[i][0];
            leds[1] = pattern[i][1];
            leds[2] = pattern[i][2];
            leds[3] = pattern[i][3];
            wait(0.2);
            i++;
            i == 6? i=0:0;
        }
    }
}

void sendSms()
{
    // Set message mode to ASCII
    GPRS.printf("AT+CMGF=1\r\n");
    wait(1);
    // Set the phone number
    GPRS.printf("AT+CMGS=\"+61435404829\"\r\n");
    wait(1);
    // Write out the GPS data in a message
    GPRS.printf("Time: %4.2f \nAltitude: %3.2fm\nSpeed: %3.2f Kn\nHeading: %3.2f Deg\nValidity: %c\nFix: %s\nSatellites: %d", gps.time, gps.altitude, gps.speed, gps.heading,gps.validity,gps.fixtype,gps.satellites);
    wait(1);
    // Send it...
    GPRS.putc(0x1A);
    wait(3);
    GPRS.printf("AT+CMGF=1\r\n");
    wait(1);
    GPRS.printf("AT+CMGS=\"+61435404829\"\r\n");
    wait(1);
    GPRS.printf("Find me at....\n %s%f,%f%s", GoogleChunk, gps.latitude, gps.longitude, GoogleExtras);
    wait(1);
    GPRS.putc(0x1A);
    wait(1);
}

void parseSms()
{
    // If theres a char waiting in the MODSERIAL buffer
    while (GPRS.readable()) {
        // Assign it to 'c'
        char c = GPRS.getc();
        // Replace all returns and or line endings with money!
        if (c == '\r' || c == '\n') c = '$';
        // Put it in the array
        GPRSbuffer[i] = c;
        // Repeat if possible
        i++;
    }
    // Uncomment the following to debug

    pc.printf("buffer = %s", GPRSbuffer);


    // If we get an SMS notification....
    if (sscanf(GPRSbuffer, "$$+CMTI: \"SM\",%d", &index)>0) {
        pc.printf("\nSMS recieved @ index [%d]", index);
        // Do the send SMS routine...
        sendSms();
        // Wait for the cascade of \r\nOK\r\n\r\nOK\r\n's from the SMS's to finish
        wait(4);
        // Flush out any left in the serial buffer
        GPRS.rxBufferFlush();
        // Reset the GPRS buffer
        memset(GPRSbuffer, '0', 512);
        // Reset the char counter
        i = 0;
    } 
   if (strncmp(GPRSbuffer, "$$RING",6) == 0) {
        //dump = "fixed";
        GPRS.printf("ATH0\r\n");
        wait(1);
        // Flush any incoming rings in the MODSERIAL buffer
        GPRS.rxBufferFlush();
        pc.printf("\nCall recieved");
        // Do the send SMS routine...
        sendSms();
        // Wait for the cascade of [\r\nOK\r\n][\r\nOK\r\n]'s from the SMS's to finish
        wait(4);
        // Flush out any left in the serial buffer
        GPRS.rxBufferFlush();
        // Reset the GPRS buffer
        memset(GPRSbuffer, '0', 512);
        // Reset the char counter
        i = 0;
    } else {
        GPRS.rxBufferFlush();
        // Reset the GPRS buffer
        memset(GPRSbuffer, '0', 512);
        // Reset the char counter
        i = 0;
        pc.printf("\nWaiting for SMS or call...\n");
    }
}

int main()
{
    pc.baud(115200);
    GPRS.baud(19200);
    Thread thread(led_thread);
    memset(GPRSbuffer, '0', 512);
    pc.printf("I'm Alive...\n");
    // Setup the GPS
    gps.Init();
    // Set the GPRS AT echo off
    GPRS.printf("ATE0\r\n");
    pc.printf("GPRS Echo OFF\n");
    wait(1);
    // Delete all messages on the sim card
    GPRS.printf("AT+CMGDA=\"DEL ALL\"\r\n");
    wait(1);
    pc.printf("Messages Cleared...\n");
    wait(1);
    // Flush out any \r\nOK\r\n's
    GPRS.rxBufferFlush();
    // Get in a while loop
    while (1) {
        // Process any recieved data
        parseSms();
        // Process / check GPS data
        gps.parseData();
    }
}
