#include "mbed.h"
#include "GPS.h"
#include "rtos.h"
#include "MODSERIAL.h"
#include <string>

using namespace std;

const string GoogleChunk = "https://maps.google.com.au/maps?q=";
const string GoogleExtras = "&z=20";
char GPRSbuffer[513];
char NUMBER[13];
char MESSAGE[5];
int index;
int i = 0;

GPS gps(p9,p10);
MODSERIAL GPRS(p13,p14);                                      
MODSERIAL pc(USBTX,USBRX);

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

void led_thread(void const *argument)                         // Some light jazz in a thread
{
    while (true) {
        DigitalOut leds[4] = {myled1, myled2, myled3, myled4};
        int pattern[6][4] = {{1,0,0,0},{0,1,0,0},{0,0,1,0},{0,0,0,1},{0,0,1,0},{0,1,0,0}};
        int i=0;
        while(1) {
            leds[0] = pattern[i][0];
            leds[1] = pattern[i][1];
            leds[2] = pattern[i][2];
            leds[3] = pattern[i][3];
            wait(0.2);
            i++;
            i == 6? i=0:0;
        }
    }
}

void sendSms()
{
    // Set message mode to ASCII
    GPRS.printf("AT+CMGF=1\r\n");
    wait(1);
    // Set the phone number
    GPRS.printf("AT+CMGS=\"%s\"\r\n", NUMBER);
    wait(1);
    // Write out the GPS data in a message
    GPRS.printf("UTC Time: %4.2f \nAltitude: %3.2fm\nSpeed: %3.2f Kn\nHeading: %3.2f Deg\nGPS data grade: [%c]\nSatellites in use: [%d]\nSatFix code: [%d] \nFix type: ", gps.time, gps.altitude, gps.speed, gps.heading, gps.validity, gps.satellites, gps.fixtype);
    if(gps.fixtype == 1) {
        GPRS.printf("Positive");
    }
    if(gps.fixtype == 2) {
        GPRS.printf("Differential");
    }
    wait(1);
    // Send it...
    GPRS.putc(0x1A);
    wait(4);
    GPRS.printf("AT+CMGF=1\r\n");
    wait(1);
    GPRS.printf("AT+CMGS=\"%s\"\r\n", NUMBER);
    wait(1);
    GPRS.printf("Find me at....\n %s%f,%f%s", GoogleChunk, gps.latitude, gps.longitude, GoogleExtras);
    wait(1);
    GPRS.putc(0x1A);
    wait(1);
}

void parseSms()
{
    // If theres a char waiting in the MODSERIAL buffer
    while (GPRS.readable()) {
        // Assign it to 'c'
        char c = GPRS.getc();
        // Replace all returns and or line endings with money!
        if (c == '\r' || c == '\n') c = '$';
        // Put it in the array
        GPRSbuffer[i] = c;
        // Repeat if possible
        i++;
    }
    // Uncomment the following to debug
    // pc.printf("\nbuffer = %s", GPRSbuffer);

    // If we get an SMS notification....
    if (sscanf(GPRSbuffer, "$$+CMTI: \"SM\",%d", &index)>0) {
        pc.printf("\nSMS recieved @ index [%d]", index);
        memset(GPRSbuffer, '0', 512);
        i = 0;
        GPRS.printf("AT+CMGR=%d\r\n", index);
        //wait(1);
    }

    if (strncmp(GPRSbuffer, "$$+CMGR",7) == 0 ) {
        // Get the number out
        char *n = strstr(GPRSbuffer,"+6");
        strncpy(NUMBER, n, 12);
        // Get the message out
        char *m = strstr(GPRSbuffer,"\"$$")+3;     
        strncpy(MESSAGE, m, 4);
        // Send the location
        sendSms();
        // Reset the GPRS buffer
        memset(GPRSbuffer, '0', 512);
        // Reset the char counter
        i = 0;
    }

    if (strncmp(GPRSbuffer, "$$+CMGS",7) == 0) {
        // Reset the GPRS buffer
        memset(GPRSbuffer, '0', 512);
        // Reset the char counter
        i = 0;
    }

    if (strncmp(GPRSbuffer, "$$RING",6) == 0) {
        GPRS.printf("ATH0\r\n");
        pc.printf("\nCall recieved");
        // Do the send SMS routine...
        sendSms();
        // Flush out any left in the serial buffer
        //GPRS.rxBufferFlush();
        // Reset the GPRS buffer
        memset(GPRSbuffer, '0', 512);
        // Reset the char counter
        i = 0;
    }
    pc.printf("\n\n\nWaiting for SMS or call...\n");
    pc.printf("\nThe last number was : %s", NUMBER);
    pc.printf("\nThe last message was : %s", MESSAGE);
    // Reset the GPRS buffer
    memset(GPRSbuffer, '0', 512);
    // Reset the char counter
    i = 0;
}

int main()
{
    pc.baud(115200);
    GPRS.baud(19200);
    Thread thread(led_thread);
    memset(GPRSbuffer, '0', 512);
    pc.printf("\nI'm Alive...\n");
    // Setup the GPS
    gps.Init();
    // Set the GPRS AT echo off
    GPRS.printf("ATE0\r\n");
    pc.printf("\nGPRS echo [OFF]\n");
    wait(1);
    // Delete all messages on the sim card
    GPRS.printf("AT+CMGDA=\"DEL ALL\"\r\n");
    wait(1);
    pc.printf("\nMessages Cleared...\n");
    wait(1);
    // Get in a while loop
    while (1) {
        // Process any recieved GPRS data
        parseSms();
        // Process / check GPS data
        gps.parseData();
    }
}
