#include "mbed.h"
#include "MMA7660.h"
 
#define PI 3.14159265
 
Serial pc(USBTX, USBRX);
MMA7660 MMA(p28, p27);
 
float calculateAngle(float x, float y, float z)
{
    float angle = 0;
    angle = (atan(x/sqrt((y*y)+(z*z)))*180/PI);//Calculating the pitch from formular in instructions
    pc.printf("Pitch angle is %.3f degrees\n\n\r",angle);
    angle = (atan(y/sqrt((x*x)+(z*z)))*180/PI);//Calculating the pitch from formular in instructions
    pc.printf("Roll angle is %.3f degrees\n\n\r",angle);
    wait(3);
    return angle;
}
int main()
{
    if (MMA.testConnection()) {
        pc.printf("the accelerometer is working OK\n\n\n\r");
    }
    pc.printf(" X-Axis     Y-Axis     Z-Axis   \n\r");
    while(1) {
        float x, y, z;
        for (int a = 1; a < 6; a++)
        {
            x = MMA.x();
            y = MMA.y();
            z = MMA.z();
            pc.printf("%f   %f  %f  \n\r\n", x, y, z);
        }
        calculateAngle( x, y, z);
    }
}