#include "mbed.h"

#define DEGREES_MAX 180

PwmOut myservo4(PA_7); //MOTOR PINZA
InterruptIn Puls1(D13,PullUp);//Intr Cambiar el puerto como tenga
InterruptIn Puls2(D12,PullUp);//Intr Cambiar el puerto como tenga

void mover_servo(uint8_t motor, uint8_t grados);

void imprimir1();
void cerrar_pinza(){ //intr
    mover_servo(4,175);
}

void abrir_pinza(){//intr
    mover_servo(4,150);
}

uint32_t degrees2usec(uint8_t grados){
    
    if(grados <= DEGREES_MAX)
        return int(457+grados*1880/180);
    return 457;
    
}
 
void mover_servo(uint8_t motor, uint8_t grados){
 
    uint32_t dpulse=0;
    dpulse=degrees2usec(grados);
    myservo4.pulsewidth_us(dpulse);         
}

int main(){
    
    Puls1.fall(&abrir_pinza); //intr tal cual en la parte inicial del programa
    Puls2.fall(&cerrar_pinza);//intr
    
    while (1) {
       
        wait_ms(500);
    }
}
