#include "mbed.h"
#include "DO/DO.h"
#include "MO/MO.h"
#include "rtos.h"
#include "config.h"


DigitalOut led1(LED1);

DigitalOut out(PIN_OUT);
InterruptIn in(PIN_IN);

Serial pc(USBTX,USBRX);

Ticker ticker;

char test[5]={0x01,0x01,0x01,0x01,0x01};


Thread sendCharThread;
Thread sendDataThread;

Thread receiveBitThread;
Thread receiveCharThread;
Thread receiveDataThread;




void interruptRise()
{
    receiveBitThread.signal_set(0x01);
}

void interruptFall()
{
    receiveBitThread.signal_set(0x01);
}

void wake()
{
    sendCharThread.signal_set(0x01);
    led1=!led1;
}



int main()
{
 
       
    led1=1;
    
    sendCharThread.start(&sendChar);
    sendCharThread.set_priority(osPriorityHigh);
    
    receiveBitThread.start(&receiveBit);
    receiveBitThread.set_priority(osPriorityHigh);
    receiveCharThread.start(&receiveChar);
    receiveDataThread.start(&receiveData);
    
    sendDataThread.start(&sendData);
    ticker.attach(&wake,T/2.0);
    wait(1);
    in.rise(&interruptRise);
    in.fall(&interruptFall);
    wait(1);
    int i =0;
    while(i<5) {
        createTrame(test,5);
        i++;
        }
    
}
