
#include "MO.h"

extern DigitalOut out;
extern Serial pc;

Queue<char,16> queueEnvoi;
Mail<TRAME,16> trame_box;

char calcCRC16(TRAME* trame)
{
    char length = trame->length;
    int CRC16 = 0xFFFF;
    for(char i =0x00; i<length; i++) {
        CRC16 = CRC16 ^ trame->data[i];
        for(int j = 0 ; j<8 ; j++) {
            if((CRC16 & 0x1)==0x01) {
                CRC16 = CRC16/2 ^ 0xA001;
            } else {
                CRC16 = CRC16/2;
            }
        }
    }
    return CRC16 & 0x00FF ;
}

void createTrame(char* data, char data_length)
{
    TRAME *frame = trame_box.alloc();
    frame->typeNFlag = TYPENFLAG;
    frame->length = data_length;
    frame->data = data;
    frame->ctrl = calcCRC16(frame);
    trame_box.put(frame);
}

void sendData()
{
    osEvent evt;
    TRAME* trame;
    while(1) {
        evt = trame_box.get();
        if(evt.status==osEventMail) {
            trame = (TRAME*)evt.value.p;
            queueEnvoi.put((char*)IDLE_SYNC);
            queueEnvoi.put((char*)START);
            queueEnvoi.put((char*)trame->typeNFlag);
            queueEnvoi.put((char*)trame->length);
            for(int i = 0; i<(int)(trame->length); i++) {
                queueEnvoi.put((char*)trame->data[i]);
            }
            queueEnvoi.put((char*)trame->ctrl);
            queueEnvoi.put((char*)STOP);
            trame_box.free(trame);
        }
    }
}

void sendChar()
{
    while(1) {
        osEvent evt = queueEnvoi.get();
        if(evt.status == osEventMessage) {
            char c = (char)evt.value.p;
            for(int i =0 ; i<8 ; i++) {
                if(((c>>i)&0x01)==1) {
                    out = 1;
                    Thread::signal_wait(0x01);
                    out = 0;
                    Thread::signal_wait(0x01);
                } else {
                    out = 0;
                    Thread::signal_wait(0x01);
                    out = 1;
                    Thread::signal_wait(0x01);
                }
            }
        }
    }
}



