#include "rtos.h"
#include "mbed.h"
#include "DO.h"
#include "config.h"

Queue <void,16> queueBitReception;
Queue <char,16> queueCharReception;
extern Serial pc;

Timer timer;

void receiveChar()
{
    char res;
    while(1) {
        res=0x00;
        for(int i =0; i<8; i++) {
            osEvent evt = queueBitReception.get();
            if(evt.status == osEventMessage) {
                res = res | (((char)evt.value.p)<<i);
            }
        }
        queueCharReception.put((char*)res);
    }

}

void receiveBit()
{
    timer.start();
    int oldTime;
    bool bitType=false;
    oldTime = timer.read_ms();
    while(1) {
        Thread::signal_wait(0x01);
        if(timer.read_ms()-oldTime<(T-(T*0.15))*1000){
            Thread::signal_wait(0x01);  
        } 
        else {
            bitType=!bitType;
        }
        if(bitType) {
            pc.putc(0x31);
            queueBitReception.put((void*)0x01);
        } else {
            pc.putc(0x30);
            queueBitReception.put((void*)0x00);
        }
        oldTime=timer.read_ms();
    }
}


char calcCRC16(char* trame)
{
    char length = trame[2];
    int CRC16 = 0xFFFF;
    for(char i =0x00; i<length; i++) {
        CRC16 = CRC16 ^ trame[3+i];
        for(int j = 0 ; j<8 ; j++) {
            if((CRC16 & 0x1)==0x01) {
                CRC16 = CRC16/2 ^ 0xA001;
            } else {
                CRC16 = CRC16/2;
            }
        }
    }
    return CRC16 & 0x00FF ;
}


void receiveData()
{
    osEvent evt;
    char reception;
    while(1) {
        evt = queueCharReception.get();
        if(evt.status == osEventMessage) {
            reception = (char)evt.value.p;
            if(reception == START) {
                do {
                    evt = queueCharReception.get();
                    if(evt.status == osEventMessage) {
                        reception = (char)evt.value.p;
                        pc.putc(reception);
                    }
                }while(reception!=STOP);
            }
        }
    }
}
