/*
	4DSerial - Library for 4D Systems Serial Environment.
	Released into the public domain.
*/
 
#ifndef Goldelox_Serial_4DLib_h
#define Goldelox_Serial_4DLib_h

#include "mbed.h"

#define Err4D_OK 		0
#define Err4D_Timeout		1
#define Err4D_NAK		2 // other than ACK received

#include "Goldelox_Types4D.h"	         	// Defines for 4dgl constants, generated by conversion of 4DGL constants to target language
#include "Goldelox_Const4DSerial.h"        	// Defines for 4dgl constants, generated by conversion of 4DGL constants to target language
#include "Goldelox_Const4D.h"	         	// Defines for 4dgl constants, generated by conversion of 4DGL constants to target language

typedef void (*Tcallback4D)(int, unsigned char); 

class Goldelox_Serial_4DLib
{
	public:
		Goldelox_Serial_4DLib(Serial * virtualPort);
		Tcallback4D Callback4D ;
		
		//Compound 4D Routines
		void blitComtoDisplay(short  X, short  Y, short  Width, short  Height, t4DByteArray  Pixels) ;
		void gfx_BGcolour(short  Color) ;
		void gfx_ChangeColour(short  OldColor, short  NewColor) ;
		void gfx_Circle(short  X, short  Y, short  Radius, short  Color) ;
		void gfx_CircleFilled(short  X, short  Y, short  Radius, short  Color) ;
		void gfx_Clipping(short  OnOff) ;
		void gfx_ClipWindow(short  X1, short  Y1, short  X2, short  Y2) ;
		void gfx_Cls(void) ;
		void gfx_Contrast(short  Contrast) ;
		void gfx_FrameDelay(short  Msec) ;
		void gfx_Line(short  X1, short  Y1, short  X2, short  Y2, short  Color) ;
		void gfx_LinePattern(short  Pattern) ;
		void gfx_LineTo(short  X, short  Y) ;
		void gfx_MoveTo(short  X, short  Y) ;
		void gfx_OutlineColour(short  Color) ;
		void gfx_Polygon(short  n, t4DWordArray  Xvalues, t4DWordArray  Yvalues, short  Color) ;
		void gfx_Polyline(short  n, t4DWordArray  Xvalues, t4DWordArray  Yvalues, short  Color) ;
		void gfx_PutPixel(short  X, short  Y, short  Color) ;
		void gfx_Rectangle(short  X1, short  Y1, short  X2, short  Y2, short  Color) ;
		void gfx_RectangleFilled(short  X1, short  Y1, short  X2, short  Y2, short  Color) ;
		void gfx_ScreenMode(short  ScreenMode) ;
		void gfx_Set(short  Func, short  Value) ;
		void gfx_Transparency(short  OnOff) ;
		void gfx_TransparentColour(short  Color) ;
		void gfx_Triangle(short  X1, short  Y1, short  X2, short  Y2, short  X3, short  Y3, short  Color) ;
		void media_Image(short  X, short  Y) ;
		void media_SetAdd(short  Hiword, short  Loword) ;
		void media_SetSector(short  Hiword, short  Loword) ;
		void media_Video(short  X, short  Y) ;
		void media_VideoFrame(short  X, short  Y, short  Framenumber) ;
		void pokeB(short  Address, short  ByteValue) ;
		void pokeW(short  Address, short  wordValue) ;
		void putCH(short  wordChar) ;
		void setbaudWait(short  Newrate) ;
		void SSMode(short  Parm) ;
		void SSSpeed(short  Speed) ;
		void SSTimeout(short  Seconds) ;
		void txt_Attributes(short  Attribs) ;
		void txt_BGcolour(short  Color) ;
		void txt_Bold(short  Bold) ;
		void txt_FGcolour(short  Color) ;
		void txt_FontID(short  FontNumber) ;
		void txt_Height(short  Multiplier) ;
		void txt_Inverse(short  Inverse) ;
		void txt_Italic(short  Italic) ;
		void txt_MoveCursor(short  Line, short  Column) ;
		void txt_Opacity(short  TransparentOpaque) ;
		void txt_Set(short  Func, short  Value) ;
		void txt_Underline(short  Underline) ;
		void txt_Width(short  Multiplier) ;
		void txt_Xgap(short  Pixels) ;
		void txt_Ygap(short  Pixels) ;
		void BeeP(short  Note, short  Duration) ;
		short charheight(char  TestChar) ;
		short charwidth(char  TestChar) ;
		short gfx_GetPixel(short  X, short  Y) ;
		short gfx_Orbit(short  Angle, short  Distance, short *  Xdest, short *  Ydest) ;
		void gfx_SetClipRegion(void) ;
		short joystick(void) ;
		short media_Flush(void) ;
		short media_Init(void) ;
		short media_ReadByte(void) ;
		short media_ReadWord(void) ;
		short media_WriteByte(short  Byte) ;
		short media_WriteWord(short  Word) ;
		short peekB(short  Address) ;
		short peekW(short  Address) ;
		void putstr(char *  InString) ;
		short sys_GetModel(char *  ModelStr) ;
		short sys_GetPmmC(void) ;
		short sys_GetVersion(void) ;

		void GetAck(void);
		
		//4D Global Variables Used
		int Error4D;  				// Error indicator,  used and set by Intrinsic routines
		unsigned char Error4D_Inv;	// Error byte returned from com port, onl set if error = Err_Invalid
	//	int Error_Abort4D;  		// if true routines will abort when detecting an error
		unsigned long TimeLimit4D;	// time limit in ms for total serial command duration, 2000 (2 seconds) should be adequate for most commands
									// assuming a reasonable baud rate AND low latency AND 0 for the Serial Delay Parameter
									// temporary increase might be required for very long (bitmap write, large image file opens)
									// or indeterminate (eg file_exec, file_run, file_callFunction) commands
		
	private:
                Serial * _virtualPort;

		//Intrinsic 4D Routines
		void WriteChars(char * charsout);
		void WriteBytes(char * Source, int Size);
		void WriteWords(short * Source, short Size);
		void getbytes(char * data, int size);
		short GetWord(void);
		void getString(char * outStr, int strLen);
		short GetAckResp(void);
		short GetAckRes2Words(short * word1, short * word2);
		void GetAck2Words(short * word1, short * word2);
		short GetAckResStr(char * OutStr);
	//	short GetAckResData(t4DByteArray OutData, short size);
		void SetThisBaudrate(int Newrate);
};
 
#endif
