/*
   Goldelox_Serial_4DLib.cpp - Library for 4D Systems Serial Environment.
 */

#include "mbed.h"
#include "Goldelox_Serial_4DLib.h"


Goldelox_Serial_4DLib::Goldelox_Serial_4DLib(Serial * virtualPort) {
        _virtualPort = virtualPort; 
        TimeLimit4D = 2000; // Give a default value to the timeout
        while(_virtualPort->readable())
        {
      	  _virtualPort->getc() ;
        }

}

//*********************************************************************************************//
//**********************************Intrinsic 4D Routines**************************************//
//*********************************************************************************************//

void Goldelox_Serial_4DLib::WriteChars(char * charsout)
{
	_virtualPort->printf(charsout) ;
	_virtualPort->putc(0);
}

void Goldelox_Serial_4DLib::WriteBytes(char * Source, int Size)
{
 	unsigned char wk ;
	int i ;
	for (i = 0; i < Size; i++)
	{
		wk = *Source++ ;
                _virtualPort->putc(wk) ;
	}
}

void Goldelox_Serial_4DLib::WriteWords(short * Source, short Size)
{
  short wk ;
  short i ;
  for (i = 0; i < Size; i++)
  {
    wk = *Source++ ;
    _virtualPort->putc(wk >> 8) ;
    _virtualPort->putc(wk) ;
  }
}

void Goldelox_Serial_4DLib::getbytes(char * data, int size)
{
  int readc ;
  readc  = 0 ;
  Timer t;
  t.start();
  while ((readc != size) && (t.read_ms() < TimeLimit4D))
  {
    if(_virtualPort->readable())
    {
      data[readc++] = _virtualPort->getc() ;
    }
  }
  if (readc != size)
  {
    Error4D = Err4D_Timeout ;
    if (Callback4D != NULL)
      Callback4D(Error4D, Error4D_Inv) ;
  }
}

void Goldelox_Serial_4DLib::GetAck(void)
{
  int read ;
  unsigned char readx = ' ' ;
  Error4D = Err4D_OK ;
  Timer t;
  t.start();
  read    = 0 ;
  int ms = 0;
  while ((read != 1) && (t.read_ms() < TimeLimit4D))
  {
	  ms = t.read_ms();
    if(_virtualPort->readable() != 0)
    {
      readx = _virtualPort->getc() ;
      read = 1 ;
    }
  }
  if (read == 0)
  {
    Error4D = Err4D_Timeout ;
    if (Callback4D != NULL)
      Callback4D(ms, 'T') ;
  }
  else if (readx != 6)
  {
    Error4D     = Err4D_NAK ;
    Error4D_Inv = readx ;
    if (Callback4D != NULL)
      Callback4D(Error4D, Error4D_Inv) ;
  }
}

short Goldelox_Serial_4DLib::GetWord(void)
{
  unsigned char readx[2] ;
  int readc ;
  
  if (Error4D != Err4D_OK)
    return 0 ;
  Timer t;
  t.start();
  readc    = 0 ;
  while ((readc != 2) && (t.read_ms() < TimeLimit4D))
  {
    if(_virtualPort->readable())
    {
      readx[readc++] = _virtualPort->getc() ;
    }
  }
  
  if (readc != 2)
  {
    Error4D  = Err4D_Timeout ;
    if (Callback4D != NULL)
      Callback4D(Error4D, Error4D_Inv) ;
  return 0 ;
  }
  else
    return readx[0] << 8 | readx[1] ;
}

void Goldelox_Serial_4DLib::getString(char * outStr, int strLen)
{
  int readc ;
  
  if (Error4D != Err4D_OK)
  {
    outStr[0] = 0 ;
    return ;
  }
  Timer t;
  t.start();
  readc    = 0 ;
  while ((readc != strLen) && (t.read_ms() < TimeLimit4D))
  {
    if(_virtualPort->readable())
    {
      outStr[readc++] = _virtualPort->getc() ;
    }
  }
  
  if (readc != strLen)
  {
    Error4D  = Err4D_Timeout ;
    if (Callback4D != NULL)
      Callback4D(Error4D, Error4D_Inv) ;
  }
  outStr[readc] = 0 ;
}

short Goldelox_Serial_4DLib::GetAckResp(void)
{
	GetAck() ;
	return GetWord() ;
}

short Goldelox_Serial_4DLib::GetAckRes2Words(short * word1, short * word2)
{
	int Result ;
	GetAck() ;
	Result = GetWord() ;
	*word1 = GetWord() ;
	*word2 = GetWord() ;
	return Result ;
}

void Goldelox_Serial_4DLib::GetAck2Words(short * word1, short * word2)
{
	GetAck() ;
	*word1 = GetWord() ;
	*word2 = GetWord() ;
}

short Goldelox_Serial_4DLib::GetAckResStr(char * OutStr)
{
	int Result ;
	GetAck() ;
	Result = GetWord() ;
	getString(OutStr, Result) ;
	return Result ;
}
/*
short Goldelox_Serial_4DLib::GetAckResData(t4DByteArray OutData, short size)
{
	int Result ;
	GetAck() ;
	Result = GetWord() ;
	getbytes(OutData, size) ;
	return Result ;
}
*/
void Goldelox_Serial_4DLib::SetThisBaudrate(int Newrate)
{
  int br = 0;
  while(_virtualPort->readable())
  {
	  _virtualPort->getc() ;
  }
  switch(Newrate)
  {
    case BAUD_110    : br = 110 ;
      break ;
    case BAUD_300    : br = 300 ;
      break ;
    case BAUD_600    : br = 600 ;
      break ;
    case BAUD_1200   : br = 1200 ;
      break ;
    case BAUD_2400   : br = 2400 ;
      break ;
    case BAUD_4800   : br = 4800 ;
      break ;
    case BAUD_9600   : br = 9600 ;
      break ;
   case BAUD_14400  : br = 14400 ;
      break ;
    case BAUD_19200  : br = 19200 ;
      break ;
 /*   case BAUD_31250  : br = 31250 ;
      break ;*/
    case BAUD_38400  : br = 38400 ;
      break ;
    case BAUD_56000  : br = 56000 ;
      break ;
    case BAUD_57600  : br = 57600 ;
      break ;
    case BAUD_115200 : br = 115200 ;
      break ;
/*    case BAUD_128000 : br = 133928 ; // actual rate is not 128000 ;
      break ;
    case BAUD_256000 : br = 281250 ; // actual rate is not  256000 ;
      break ;
    case BAUD_300000 : br = 312500 ; // actual rate is not  300000 ;
      break ;
    case BAUD_375000 : br = 401785 ; // actual rate is not  375000 ;
      break ;
    case BAUD_500000 : br = 562500 ; // actual rate is not  500000 ;
      break ;
    case BAUD_600000 : br = 703125 ; // actual rate is not  600000 ;
      break ;*/
  }
  _virtualPort->baud(br) ;
  wait_ms(50); // Display sleeps for 100
  while(_virtualPort->readable())
  {
	  _virtualPort->getc() ;
  }
}

//*********************************************************************************************//
//**********************************Compound 4D Routines***************************************//
//*********************************************************************************************//

short Goldelox_Serial_4DLib::charheight(char  TestChar)
{
  _virtualPort->putc((char)(F_charheight >> 8)) ;
  _virtualPort->putc((char)(F_charheight)) ;
  _virtualPort->putc((char)(TestChar)) ;
  return GetAckResp() ;
}

short Goldelox_Serial_4DLib::charwidth(char  TestChar)
{
  _virtualPort->putc((char)(F_charwidth >> 8)) ;
  _virtualPort->putc((char)(F_charwidth)) ;
  _virtualPort->putc((char)(TestChar)) ;
  return GetAckResp() ;
}

void Goldelox_Serial_4DLib::gfx_BGcolour(short  Color)
{
  _virtualPort->putc((char)(F_gfx_BGcolour >> 8)) ;
  _virtualPort->putc((char)(F_gfx_BGcolour)) ;
  _virtualPort->putc((char)(Color >> 8)) ;
  _virtualPort->putc((char)(Color)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::gfx_ChangeColour(short  OldColor, short  NewColor)
{
  _virtualPort->putc((char)(F_gfx_ChangeColour >> 8)) ;
  _virtualPort->putc((char)(F_gfx_ChangeColour)) ;
  _virtualPort->putc((char)(OldColor >> 8)) ;
  _virtualPort->putc((char)(OldColor)) ;
  _virtualPort->putc((char)(NewColor >> 8)) ;
  _virtualPort->putc((char)(NewColor)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::gfx_Circle(short  X, short  Y, short  Radius, short  Color)
{
  _virtualPort->putc((char)(F_gfx_Circle >> 8)) ;
  _virtualPort->putc((char)(F_gfx_Circle)) ;
  _virtualPort->putc((char)(X >> 8)) ;
  _virtualPort->putc((char)(X)) ;
  _virtualPort->putc((char)(Y >> 8)) ;
  _virtualPort->putc((char)(Y)) ;
  _virtualPort->putc((char)(Radius >> 8)) ;
  _virtualPort->putc((char)(Radius)) ;
  _virtualPort->putc((char)(Color >> 8)) ;
  _virtualPort->putc((char)(Color)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::gfx_CircleFilled(short  X, short  Y, short  Radius, short  Color)
{
  _virtualPort->putc((char)(F_gfx_CircleFilled >> 8)) ;
  _virtualPort->putc((char)(F_gfx_CircleFilled)) ;
  _virtualPort->putc((char)(X >> 8)) ;
  _virtualPort->putc((char)(X)) ;
  _virtualPort->putc((char)(Y >> 8)) ;
  _virtualPort->putc((char)(Y)) ;
  _virtualPort->putc((char)(Radius >> 8)) ;
  _virtualPort->putc((char)(Radius)) ;
  _virtualPort->putc((char)(Color >> 8)) ;
  _virtualPort->putc((char)(Color)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::gfx_Clipping(short  OnOff)
{
  _virtualPort->putc((char)(F_gfx_Clipping >> 8)) ;
  _virtualPort->putc((char)(F_gfx_Clipping)) ;
  _virtualPort->putc((char)(OnOff >> 8)) ;
  _virtualPort->putc((char)(OnOff)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::gfx_ClipWindow(short  X1, short  Y1, short  X2, short  Y2)
{
  _virtualPort->putc((char)(F_gfx_ClipWindow >> 8)) ;
  _virtualPort->putc((char)(F_gfx_ClipWindow)) ;
  _virtualPort->putc((char)(X1 >> 8)) ;
  _virtualPort->putc((char)(X1)) ;
  _virtualPort->putc((char)(Y1 >> 8)) ;
  _virtualPort->putc((char)(Y1)) ;
  _virtualPort->putc((char)(X2 >> 8)) ;
  _virtualPort->putc((char)(X2)) ;
  _virtualPort->putc((char)(Y2 >> 8)) ;
  _virtualPort->putc((char)(Y2)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::gfx_Cls()
{
  _virtualPort->putc((char)(F_gfx_Cls >> 8)) ;
  _virtualPort->putc((char)(F_gfx_Cls)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::gfx_Contrast(short  Contrast)
{
  _virtualPort->putc((char)(F_gfx_Contrast >> 8)) ;
  _virtualPort->putc((char)(F_gfx_Contrast)) ;
  _virtualPort->putc((char)(Contrast >> 8)) ;
  _virtualPort->putc((char)(Contrast)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::gfx_FrameDelay(short  Msec)
{
  _virtualPort->putc((char)(F_gfx_FrameDelay >> 8)) ;
  _virtualPort->putc((char)(F_gfx_FrameDelay)) ;
  _virtualPort->putc((char)(Msec >> 8)) ;
  _virtualPort->putc((char)(Msec)) ;
  GetAck() ;
}

short Goldelox_Serial_4DLib::gfx_GetPixel(short  X, short  Y)
{
  _virtualPort->putc((char)(F_gfx_GetPixel >> 8 )) ;
  _virtualPort->putc((char)(F_gfx_GetPixel )) ;
  _virtualPort->putc((char)(X >> 8 )) ;
  _virtualPort->putc((char)(X )) ;
  _virtualPort->putc((char)(Y >> 8 )) ;
  _virtualPort->putc((char)(Y )) ;
  return GetAckResp() ;
}

void Goldelox_Serial_4DLib::gfx_Line(short  X1, short  Y1, short  X2, short  Y2, short  Color)
{
  _virtualPort->putc((char)(F_gfx_Line >> 8 )) ;
  _virtualPort->putc((char)(F_gfx_Line )) ;
  _virtualPort->putc((char)(X1 >> 8 )) ;
  _virtualPort->putc((char)(X1 )) ;
  _virtualPort->putc((char)(Y1 >> 8 )) ;
  _virtualPort->putc((char)(Y1 )) ;
  _virtualPort->putc((char)(X2 >> 8 )) ;
  _virtualPort->putc((char)(X2 )) ;
  _virtualPort->putc((char)(Y2 >> 8 )) ;
  _virtualPort->putc((char)(Y2 )) ;
  _virtualPort->putc((char)(Color >> 8 )) ;
  _virtualPort->putc((char)(Color )) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::gfx_LinePattern(short  Pattern)
{
  _virtualPort->putc((char)(F_gfx_LinePattern >> 8 )) ;
  _virtualPort->putc((char)(F_gfx_LinePattern )) ;
  _virtualPort->putc((char)(Pattern >> 8 )) ;
  _virtualPort->putc((char)(Pattern )) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::gfx_LineTo(short  X, short  Y)
{
  _virtualPort->putc((char)(F_gfx_LineTo >> 8 )) ;
  _virtualPort->putc((char)(F_gfx_LineTo )) ;
  _virtualPort->putc((char)(X >> 8 )) ;
  _virtualPort->putc((char)(X )) ;
  _virtualPort->putc((char)(Y >> 8 )) ;
  _virtualPort->putc((char)(Y )) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::gfx_MoveTo(short  X, short  Y)
{
  _virtualPort->putc((char)(F_gfx_MoveTo >> 8 )) ;
  _virtualPort->putc((char)(F_gfx_MoveTo )) ;
  _virtualPort->putc((char)(X >> 8 )) ;
  _virtualPort->putc((char)(X )) ;
  _virtualPort->putc((char)(Y >> 8 )) ;
  _virtualPort->putc((char)(Y )) ;
  GetAck() ;
}

short Goldelox_Serial_4DLib::gfx_Orbit(short  Angle, short  Distance, short *  Xdest, short *  Ydest)
{
  _virtualPort->putc((char)(F_gfx_Orbit >> 8 )) ;
  _virtualPort->putc((char)(F_gfx_Orbit )) ;
  _virtualPort->putc((char)(Angle >> 8 )) ;
  _virtualPort->putc((char)(Angle )) ;
  _virtualPort->putc((char)(Distance >> 8 )) ;
  _virtualPort->putc((char)(Distance )) ;
  GetAck2Words(Xdest,Ydest) ;
  return 0 ;
}

void Goldelox_Serial_4DLib::gfx_OutlineColour(short  Color)
{
  _virtualPort->putc((char)(F_gfx_OutlineColour >> 8 )) ;
  _virtualPort->putc((char)(F_gfx_OutlineColour )) ;
  _virtualPort->putc((char)(Color >> 8 )) ;
  _virtualPort->putc((char)(Color )) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::gfx_Polygon(short  n, t4DWordArray  Xvalues, t4DWordArray  Yvalues, short  Color)
{
  _virtualPort->putc((char)(F_gfx_Polygon >> 8 )) ;
  _virtualPort->putc((char)(F_gfx_Polygon )) ;
  _virtualPort->putc((char)(n >> 8 )) ;
  _virtualPort->putc((char)(n )) ;
  WriteWords(Xvalues, (int)n) ;
  WriteWords(Yvalues, (int)n) ;
  _virtualPort->putc((char)(Color >> 8 )) ;
  _virtualPort->putc((char)(Color )) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::gfx_Polyline(short  n, t4DWordArray  Xvalues, t4DWordArray  Yvalues, short  Color)
{
  _virtualPort->putc((char)(F_gfx_Polyline >> 8 )) ;
  _virtualPort->putc((char)(F_gfx_Polyline )) ;
  _virtualPort->putc((char)(n >> 8 )) ;
  _virtualPort->putc((char)(n )) ;
  WriteWords(Xvalues, n) ;
  WriteWords(Yvalues, n) ;
  _virtualPort->putc((char)(Color >> 8 )) ;
  _virtualPort->putc((char)(Color )) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::gfx_PutPixel(short  X, short  Y, short  Color)
{
  _virtualPort->putc((char)(F_gfx_PutPixel >> 8 )) ;
  _virtualPort->putc((char)(F_gfx_PutPixel )) ;
  _virtualPort->putc((char)(X >> 8 )) ;
  _virtualPort->putc((char)(X )) ;
  _virtualPort->putc((char)(Y >> 8 )) ;
  _virtualPort->putc((char)(Y )) ;
  _virtualPort->putc((char)(Color >> 8 )) ;
  _virtualPort->putc((char)(Color )) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::gfx_Rectangle(short  X1, short  Y1, short  X2, short  Y2, short  Color)
{
  _virtualPort->putc((char)(F_gfx_Rectangle >> 8 )) ;
  _virtualPort->putc((char)(F_gfx_Rectangle )) ;
  _virtualPort->putc((char)(X1 >> 8 )) ;
  _virtualPort->putc((char)(X1 )) ;
  _virtualPort->putc((char)(Y1 >> 8 )) ;
  _virtualPort->putc((char)(Y1 )) ;
  _virtualPort->putc((char)(X2 >> 8 )) ;
  _virtualPort->putc((char)(X2 )) ;
  _virtualPort->putc((char)(Y2 >> 8 )) ;
  _virtualPort->putc((char)(Y2 )) ;
  _virtualPort->putc((char)(Color >> 8 )) ;
  _virtualPort->putc((char)(Color )) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::gfx_RectangleFilled(short  X1, short  Y1, short  X2, short  Y2, short  Color)
{
  _virtualPort->putc((char)(F_gfx_RectangleFilled >> 8 )) ;
  _virtualPort->putc((char)(F_gfx_RectangleFilled )) ;
  _virtualPort->putc((char)(X1 >> 8 )) ;
  _virtualPort->putc((char)(X1 )) ;
  _virtualPort->putc((char)(Y1 >> 8 )) ;
  _virtualPort->putc((char)(Y1 )) ;
  _virtualPort->putc((char)(X2 >> 8 )) ;
  _virtualPort->putc((char)(X2 )) ;
  _virtualPort->putc((char)(Y2 >> 8 )) ;
  _virtualPort->putc((char)(Y2 )) ;
  _virtualPort->putc((char)(Color >> 8 )) ;
  _virtualPort->putc((char)(Color )) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::gfx_ScreenMode(short  ScreenMode)
{
  _virtualPort->putc((char)(F_gfx_ScreenMode >> 8 )) ;
  _virtualPort->putc((char)(F_gfx_ScreenMode )) ;
  _virtualPort->putc((char)(ScreenMode >> 8 )) ;
  _virtualPort->putc((char)(ScreenMode )) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::gfx_Set(short  Func, short  Value)
{
  _virtualPort->putc((char)(F_gfx_Set >> 8 )) ;
  _virtualPort->putc((char)(F_gfx_Set )) ;
  _virtualPort->putc((char)(Func >> 8 )) ;
  _virtualPort->putc((char)(Func )) ;
  _virtualPort->putc((char)(Value >> 8 )) ;
  _virtualPort->putc((char)(Value )) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::gfx_SetClipRegion()
{
  _virtualPort->putc((char)(F_gfx_SetClipRegion >> 8)) ;
  _virtualPort->putc((char)(F_gfx_SetClipRegion)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::gfx_Transparency(short  OnOff)
{
  _virtualPort->putc((char)(F_gfx_Transparency >> 8)) ;
  _virtualPort->putc((char)(F_gfx_Transparency)) ;
  _virtualPort->putc((char)(OnOff >> 8)) ;
  _virtualPort->putc((char)(OnOff)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::gfx_TransparentColour(short  Color)
{
  _virtualPort->putc((char)(F_gfx_TransparentColour >> 8)) ;
  _virtualPort->putc((char)(F_gfx_TransparentColour)) ;
  _virtualPort->putc((char)(Color >> 8)) ;
  _virtualPort->putc((char)(Color)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::gfx_Triangle(short  X1, short  Y1, short  X2, short  Y2, short  X3, short  Y3, short  Color)
{
  _virtualPort->putc((char)(F_gfx_Triangle >> 8)) ;
  _virtualPort->putc((char)(F_gfx_Triangle)) ;
  _virtualPort->putc((char)(X1 >> 8)) ;
  _virtualPort->putc((char)(X1)) ;
  _virtualPort->putc((char)(Y1 >> 8)) ;
  _virtualPort->putc((char)(Y1)) ;
  _virtualPort->putc((char)(X2 >> 8)) ;
  _virtualPort->putc((char)(X2)) ;
  _virtualPort->putc((char)(Y2 >> 8)) ;
  _virtualPort->putc((char)(Y2)) ;
  _virtualPort->putc((char)(X3 >> 8)) ;
  _virtualPort->putc((char)(X3)) ;
  _virtualPort->putc((char)(Y3 >> 8)) ;
  _virtualPort->putc((char)(Y3)) ;
  _virtualPort->putc((char)(Color >> 8)) ;
  _virtualPort->putc((char)(Color)) ;
  GetAck() ;
}

short Goldelox_Serial_4DLib::media_Flush()
{
  _virtualPort->putc((char)(F_media_Flush >> 8)) ;
  _virtualPort->putc((char)(F_media_Flush)) ;
  return GetAckResp() ;
}

void Goldelox_Serial_4DLib::media_Image(short  X, short  Y)
{
  _virtualPort->putc((char)(F_media_Image >> 8)) ;
  _virtualPort->putc((char)(F_media_Image)) ;
  _virtualPort->putc((char)(X >> 8)) ;
  _virtualPort->putc((char)(X)) ;
  _virtualPort->putc((char)(Y >> 8)) ;
  _virtualPort->putc((char)(Y)) ;
  GetAck() ;
}

short Goldelox_Serial_4DLib::media_Init()
{
  _virtualPort->putc((char)(F_media_Init >> 8)) ;
  _virtualPort->putc((char)(F_media_Init)) ;
  return GetAckResp() ;
}

short Goldelox_Serial_4DLib::media_ReadByte()
{
  _virtualPort->putc((char)(F_media_ReadByte >> 8)) ;
  _virtualPort->putc((char)(F_media_ReadByte)) ;
  return GetAckResp() ;
}

short Goldelox_Serial_4DLib::media_ReadWord()
{
  _virtualPort->putc((char)(F_media_ReadWord >> 8)) ;
  _virtualPort->putc((char)(F_media_ReadWord)) ;
  return GetAckResp() ;
}

void Goldelox_Serial_4DLib::media_SetAdd(short  HiWord, short  LoWord)
{
  _virtualPort->putc((char)(F_media_SetAdd >> 8)) ;
  _virtualPort->putc((char)(F_media_SetAdd)) ;
  _virtualPort->putc((char)(HiWord >> 8)) ;
  _virtualPort->putc((char)(HiWord)) ;
  _virtualPort->putc((char)(LoWord >> 8)) ;
  _virtualPort->putc((char)(LoWord)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::media_SetSector(short  HiWord, short  LoWord)
{
  _virtualPort->putc((char)(F_media_SetSector >> 8)) ;
  _virtualPort->putc((char)(F_media_SetSector)) ;
  _virtualPort->putc((char)(HiWord >> 8)) ;
  _virtualPort->putc((char)(HiWord)) ;
  _virtualPort->putc((char)(LoWord >> 8)) ;
  _virtualPort->putc((char)(LoWord)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::media_Video(short  X, short  Y)
{
  _virtualPort->putc((char)(F_media_Video >> 8)) ;
  _virtualPort->putc((char)(F_media_Video)) ;
  _virtualPort->putc((char)(X >> 8)) ;
  _virtualPort->putc((char)(X)) ;
  _virtualPort->putc((char)(Y >> 8)) ;
  _virtualPort->putc((char)(Y)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::media_VideoFrame(short  X, short  Y, short  Framenumber)
{
  _virtualPort->putc((char)(F_media_VideoFrame >> 8)) ;
  _virtualPort->putc((char)(F_media_VideoFrame)) ;
  _virtualPort->putc((char)(X >> 8)) ;
  _virtualPort->putc((char)(X)) ;
  _virtualPort->putc((char)(Y >> 8)) ;
  _virtualPort->putc((char)(Y)) ;
  _virtualPort->putc((char)(Framenumber >> 8)) ;
  _virtualPort->putc((char)(Framenumber)) ;
  GetAck() ;
}

short Goldelox_Serial_4DLib::media_WriteByte(short  Byte)
{
  _virtualPort->putc((char)(F_media_WriteByte >> 8)) ;
  _virtualPort->putc((char)(F_media_WriteByte)) ;
  _virtualPort->putc((char)(Byte >> 8)) ;
  _virtualPort->putc((char)(Byte)) ;
  return GetAckResp() ;
}

short Goldelox_Serial_4DLib::media_WriteWord(short  Word)
{
  _virtualPort->putc((char)(F_media_WriteWord >> 8)) ;
  _virtualPort->putc((char)(F_media_WriteWord)) ;
  _virtualPort->putc((char)(Word >> 8)) ;
  _virtualPort->putc((char)(Word)) ;
  return GetAckResp() ;
}

void Goldelox_Serial_4DLib::putCH(short  WordChar)
{
  _virtualPort->putc((char)(F_putCH >> 8)) ;
  _virtualPort->putc((char)(F_putCH)) ;
  _virtualPort->putc((char)(WordChar >> 8)) ;
  _virtualPort->putc((char)(WordChar)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::putstr(char *  InString)
{
  _virtualPort->putc((char)(F_putstr >> 8)) ;
  _virtualPort->putc((char)(F_putstr)) ;
  WriteChars(InString) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::txt_Attributes(short  Attribs)
{
  _virtualPort->putc((char)(F_txt_Attributes >> 8)) ;
  _virtualPort->putc((char)(F_txt_Attributes)) ;
  _virtualPort->putc((char)(Attribs >> 8)) ;
  _virtualPort->putc((char)(Attribs)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::txt_BGcolour(short  Color)
{
  _virtualPort->putc((char)(F_txt_BGcolour >> 8)) ;
  _virtualPort->putc((char)(F_txt_BGcolour)) ;
  _virtualPort->putc((char)(Color >> 8)) ;
  _virtualPort->putc((char)(Color)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::txt_Bold(short  Bold)
{
  _virtualPort->putc((char)(F_txt_Bold >> 8)) ;
  _virtualPort->putc((char)(F_txt_Bold)) ;
  _virtualPort->putc((char)(Bold >> 8)) ;
  _virtualPort->putc((char)(Bold)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::txt_FGcolour(short  Color)
{
  _virtualPort->putc((char)(F_txt_FGcolour >> 8)) ;
  _virtualPort->putc((char)(F_txt_FGcolour)) ;
  _virtualPort->putc((char)(Color >> 8)) ;
  _virtualPort->putc((char)(Color)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::txt_FontID(short  FontNumber)
{
  _virtualPort->putc((char)(F_txt_FontID >> 8)) ;
  _virtualPort->putc((char)(F_txt_FontID)) ;
  _virtualPort->putc((char)(FontNumber >> 8)) ;
  _virtualPort->putc((char)(FontNumber)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::txt_Height(short  Multiplier)
{
  _virtualPort->putc((char)(F_txt_Height >> 8)) ;
  _virtualPort->putc((char)(F_txt_Height)) ;
  _virtualPort->putc((char)(Multiplier >> 8)) ;
  _virtualPort->putc((char)(Multiplier)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::txt_Inverse(short  Inverse)
{
  _virtualPort->putc((char)(F_txt_Inverse >> 8)) ;
  _virtualPort->putc((char)(F_txt_Inverse)) ;
  _virtualPort->putc((char)(Inverse >> 8)) ;
  _virtualPort->putc((char)(Inverse)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::txt_Italic(short  Italic)
{
  _virtualPort->putc((char)(F_txt_Italic >> 8)) ;
  _virtualPort->putc((char)(F_txt_Italic)) ;
  _virtualPort->putc((char)(Italic >> 8)) ;
  _virtualPort->putc((char)(Italic)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::txt_MoveCursor(short  Line, short  Column)
{
  _virtualPort->putc((char)(F_txt_MoveCursor >> 8)) ;
  _virtualPort->putc((char)(F_txt_MoveCursor)) ;
  _virtualPort->putc((char)(Line >> 8)) ;
  _virtualPort->putc((char)(Line)) ;
  _virtualPort->putc((char)(Column >> 8)) ;
  _virtualPort->putc((char)(Column)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::txt_Opacity(short  TransparentOpaque)
{
  _virtualPort->putc((char)(F_txt_Opacity >> 8)) ;
  _virtualPort->putc((char)(F_txt_Opacity)) ;
  _virtualPort->putc((char)(TransparentOpaque >> 8)) ;
  _virtualPort->putc((char)(TransparentOpaque)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::txt_Set(short  Func, short  Value)
{
  _virtualPort->putc((char)(F_txt_Set >> 8)) ;
  _virtualPort->putc((char)(F_txt_Set)) ;
  _virtualPort->putc((char)(Func >> 8)) ;
  _virtualPort->putc((char)(Func)) ;
  _virtualPort->putc((char)(Value >> 8)) ;
  _virtualPort->putc((char)(Value)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::txt_Underline(short  Underline)
{
  _virtualPort->putc((char)(F_txt_Underline >> 8)) ;
  _virtualPort->putc((char)(F_txt_Underline)) ;
  _virtualPort->putc((char)(Underline >> 8)) ;
  _virtualPort->putc((char)(Underline)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::txt_Width(short  Multiplier)
{
  _virtualPort->putc((char)(F_txt_Width >> 8)) ;
  _virtualPort->putc((char)(F_txt_Width)) ;
  _virtualPort->putc((char)(Multiplier >> 8)) ;
  _virtualPort->putc((char)(Multiplier)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::txt_Xgap(short  Pixels)
{
  _virtualPort->putc((char)(F_txt_Xgap >> 8)) ;
  _virtualPort->putc((char)(F_txt_Xgap)) ;
  _virtualPort->putc((char)(Pixels >> 8)) ;
  _virtualPort->putc((char)(Pixels)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::txt_Ygap(short  Pixels)
{
  _virtualPort->putc((char)(F_txt_Ygap >> 8)) ;
  _virtualPort->putc((char)(F_txt_Ygap)) ;
  _virtualPort->putc((char)(Pixels >> 8)) ;
  _virtualPort->putc((char)(Pixels)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::BeeP(short  Note, short  Duration)
{
  _virtualPort->putc((char)(F_BeeP >> 8)) ;
  _virtualPort->putc((char)(F_BeeP)) ;
  _virtualPort->putc((char)(Note >> 8)) ;
  _virtualPort->putc((char)(Note)) ;
  _virtualPort->putc((char)(Duration >> 8)) ;
  _virtualPort->putc((char)(Duration)) ;
  GetAck() ;
}

short Goldelox_Serial_4DLib::sys_GetModel(char *  ModelStr)
{
  _virtualPort->putc((char)(F_sys_GetModel >> 8)) ;
  _virtualPort->putc((char)(F_sys_GetModel)) ;
  return GetAckResStr(ModelStr) ;
}

short Goldelox_Serial_4DLib::sys_GetVersion()
{
  _virtualPort->putc((char)(F_sys_GetVersion >> 8)) ;
  _virtualPort->putc((char)(F_sys_GetVersion)) ;
  return GetAckResp() ;
}

short Goldelox_Serial_4DLib::sys_GetPmmC()
{
  _virtualPort->putc((char)(F_sys_GetPmmC >> 8)) ;
  _virtualPort->putc((char)(F_sys_GetPmmC)) ;
  return GetAckResp() ;
}

void Goldelox_Serial_4DLib::blitComtoDisplay(short  X, short  Y, short  Width, short  Height, t4DByteArray  Pixels)
{
  _virtualPort->putc((char)(F_blitComtoDisplay >> 8)) ;
  _virtualPort->putc((char)(F_blitComtoDisplay)) ;
  _virtualPort->putc((char)(X >> 8)) ;
  _virtualPort->putc((char)(X)) ;
  _virtualPort->putc((char)(Y >> 8)) ;
  _virtualPort->putc((char)(Y)) ;
  _virtualPort->putc((char)(Width >> 8)) ;
  _virtualPort->putc((char)(Width)) ;
  _virtualPort->putc((char)(Height >> 8)) ;
  _virtualPort->putc((char)(Height)) ;
  WriteBytes(Pixels, Width*Height*2) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::setbaudWait(short  Newrate)
{
  _virtualPort->putc((char)(F_setbaudWait >> 8)) ;
  _virtualPort->putc((char)(F_setbaudWait)) ;
  _virtualPort->putc((char)(Newrate >> 8)) ;
  _virtualPort->putc((char)(Newrate)) ;
  SetThisBaudrate(Newrate) ; // change this systems baud rate to match new display rate, ACK is 100ms away
  GetAck() ;
}

short Goldelox_Serial_4DLib::peekW(short  Address)
{
  _virtualPort->putc((char)(F_peekW >> 8)) ;
  _virtualPort->putc((char)(F_peekW)) ;
  _virtualPort->putc((char)(Address >> 8)) ;
  _virtualPort->putc((char)(Address)) ;
  return GetAckResp() ;
}

void Goldelox_Serial_4DLib::pokeW(short  Address, short  WordValue)
{
  _virtualPort->putc((char)(F_pokeW >> 8)) ;
  _virtualPort->putc((char)(F_pokeW)) ;
  _virtualPort->putc((char)(Address >> 8)) ;
  _virtualPort->putc((char)(Address)) ;
  _virtualPort->putc((char)(WordValue >> 8)) ;
  _virtualPort->putc((char)(WordValue)) ;
  GetAck() ;
}

short Goldelox_Serial_4DLib::peekB(short  Address)
{
  _virtualPort->putc((char)(F_peekB >> 8)) ;
  _virtualPort->putc((char)(F_peekB)) ;
  _virtualPort->putc((char)(Address >> 8)) ;
  _virtualPort->putc((char)(Address)) ;
  return GetAckResp() ;
}

void Goldelox_Serial_4DLib::pokeB(short  Address, short  ByteValue)
{
  _virtualPort->putc((char)(F_pokeB >> 8)) ;
  _virtualPort->putc((char)(F_pokeB)) ;
  _virtualPort->putc((char)(Address >> 8)) ;
  _virtualPort->putc((char)(Address)) ;
  _virtualPort->putc((char)(ByteValue >> 8)) ;
  _virtualPort->putc((char)(ByteValue)) ;
  GetAck() ;
}

short Goldelox_Serial_4DLib::joystick()
{
  _virtualPort->putc((char)(F_joystick >> 8)) ;
  _virtualPort->putc((char)(F_joystick)) ;
  return GetAckResp() ;
}

void Goldelox_Serial_4DLib::SSTimeout(short  Seconds)
{
  _virtualPort->putc((char)(F_SSTimeout >> 8)) ;
  _virtualPort->putc((char)(F_SSTimeout)) ;
  _virtualPort->putc((char)(Seconds >> 8)) ;
  _virtualPort->putc((char)(Seconds)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::SSSpeed(short  Speed)
{
  _virtualPort->putc((char)(F_SSSpeed >> 8)) ;
  _virtualPort->putc((char)(F_SSSpeed)) ;
  _virtualPort->putc((char)(Speed >> 8)) ;
  _virtualPort->putc((char)(Speed)) ;
  GetAck() ;
}

void Goldelox_Serial_4DLib::SSMode(short  Parm)
{
  _virtualPort->putc((char)(F_SSMode >> 8)) ;
  _virtualPort->putc((char)(F_SSMode)) ;
  _virtualPort->putc((char)(Parm >> 8)) ;
  _virtualPort->putc((char)(Parm)) ;
  GetAck() ;
}
