#include "ARS.h"


ARS::ARS(PinName tx,PinName rx) : _ARS(tx,rx)
{
    rollAngle=0;
    pitchAngle=0;
    rollVel=0;
    pitchVel=0;
} //생성자

void ARS::set(int baudRate=115200)
{
    _ARS.baud(baudRate);
    _ARS.printf("<CAH>");
}

void ARS::getdata() //데이터를 한줄만 받는다.
{
    char incomingByte=0;
    int resultValues=0;
    int consideringMinusSign=1;
    int selectingValuesFromARS=0;


    while(true) {

        incomingByte=_ARS.getc();

        // Operation minus sign.
        if(incomingByte == '-') {
            consideringMinusSign = -1;
        }

        //Operation number type
        if(incomingByte >= '0' && incomingByte <= '9') {
            resultValues = resultValues*10 + incomingByte - '0';
        }

        //Operation end of data
        if(incomingByte == ',' || incomingByte == '>') {
            resultValues = resultValues * consideringMinusSign;
            consideringMinusSign = 1; //next calculation, using plus sign
            selectingValuesFromARS += 1;  //increase the var.

            switch(selectingValuesFromARS) {
                case 1 : // getting roll angle as degree
                    rollAngle = resultValues * scaleFactorOfARS * rad2degree;
                    break;
                case 2 : // getting pitch angle as degree
                    pitchAngle = resultValues * scaleFactorOfARS * rad2degree;
                    break;
                case 3 : // getting roll anglular velocity as degree
                    rollVel = resultValues * scaleFactorOfARS * rad2degree;
                    break;

                case 4 : // getting pitch anglular velocity as degree
                    pitchVel = resultValues * scaleFactorOfARS * rad2degree;
                    break;
            }
            resultValues = 0; //initializing the number.
        }
        if (incomingByte == '>') {
            selectingValuesFromARS +=1;
        }
        if (selectingValuesFromARS == 5) {
            selectingValuesFromARS=0;
            break;
        }

    }
}



float ARS::getrollangle()
{
    return rollAngle;
}

float ARS::getpitchangle()
{
    return pitchAngle;
}

float ARS::getrollvel()
{
    return rollVel;
}

float ARS::getpitchvel()
{
    return pitchVel;
}
