#include "TglSW.h"
#include "mbed.h"

TglSW::TglSW(PinName SWPin) : _SW(SWPin) {}

void TglSW::Enable(int NoiseCancel)  {  // _PRSCNT -- unit [times] 
    _REPEAT   = NoiseCancel;
    _PlessCounter.attach(this, &TglSW::_SeekPress, 0.05); // Ticker[s]
    _IfPless = 0;
}

bool  TglSW::State(void){
    return _IfPless;
}

void  TglSW::Clear(void){
    _IfPless = 0;
    _PressCount = 0;
}

void TglSW::_SeekPress(void)  {        // instead of InterruptIn  -- for against noise
    if(_SW != _preSW)  _PressCount++;
    else      _PressCount=0;
    if(_PressCount > _REPEAT ){
        if(_SW ==0){
            _IfPless = !_IfPless;
            _PressCount=0;
        }
        _preSW = _SW;
    }
}
