/***********************************

****************************************/
#include "mbed.h"
#include "SPI_MIP16.h"

#ifdef LCD_SPI
#define  _spi_write _spi.write
WatchDisp::WatchDisp(PinName mosi,PinName miso,PinName sclk,PinName cs)
    : _spi(mosi, miso, sclk),_cs(cs)
{
    _cs  = 0;
     clsBUF();
    _spi.format(8,0);                   // 8bit mode3
    _spi.frequency(1000000);          // 1 Mhz SPI clock 

  
    wait_us(6);
    _cs  = 1;    
    wait_us(6);
    _spi.write(0x30);//
    _spi.write(0x00);// dummy
    wait_us(6);
    _cs  = 0; 
}
#else
WatchDisp::WatchDisp(PinName mosi,PinName miso,PinName sclk,PinName cs)
          : _mosi(mosi), _miso(miso), _sclk(sclk), _cs(cs){
//    _lcd_reset  = 0;
//    _lcd_reset  = 1;  _lcd_extmod = 1;  _lcd_extmod = 0;  // Power On Sequece
//    _lcd_disp = 0;
    _cs  = 0;
    _cs  = 1;    
    command(0x30);//
    command(0x00);// dummy
    _cs  = 0; 

}
void WatchDisp::_spi_write(uint8_t command)
{
    _sclk = 0;
    for (int b=7;b>=0;b--){
        _sclk = 0;
        _mosi = (command>>b)&0x01;
        _sclk = 1;
        //in_data = in_data | (_lcd_miso<<b);
    }
    _sclk = 0;
}
#endif


int WatchDisp::_putc(int value)
{
    if (value == '\n') {    // new line
        char_x = 0;
        char_y = char_y + font[3];
        if (char_y >= _height - font[3]) {
            char_y = 0;
        }
    } else {
        character(char_x, char_y, value);
    }
    return value;
}

int WatchDisp::_getc() {
    return -1;
}
void WatchDisp::set_font(unsigned char* f)
{
    font = f;
}

void WatchDisp::locate(int x, int y)
{
    char_x = x;
    char_y = y;
}

void WatchDisp::character(int x, int y, int c)
{
    unsigned int hor,vert,offset0,offset1,bpl,j,i,b; // T.Okamoto modified, for big font
    unsigned char* zeichen;
    unsigned char z,w;
//    int index;
    if ((c < 31) || (c > 127)) return;   // test char range

    offset0 = font[0];       // bytes / char
    offset1 = font[1];       // bytes / char
    hor = font[2];                       // get hor size of font
    vert = font[3];                      // get vert size of font
    bpl = font[4];                       // bytes per line

    if (char_x + hor > _width) {
        char_x = 0;
        char_y = char_y + vert;
        if (char_y >= _height - font[3]) char_y = 0; // original =  font[2]  T.Okamoto modified, for big font
    }
    zeichen = &font[(c -32) * (offset0 *256 + offset1) + 5]; // start of char bitmap // original =  +4  T.Okamoto modified, for big font
    w = zeichen[0];                          // width of actual char
    for (j=0; j<vert; j++) {  //  vert line
        for (i=0; i<hor; i++) {   //  horz line
            z =  zeichen[bpl * i + ((j & 0xF8) >> 3)+1];
            b = 1 << (j & 0x07);
//            index = (y+j)*_width+(x+i);
            if (( z & b ) != 0x00)  pixel(x+i,y+j,_foreground);
            else if (_ifMarge == 0) pixel(x+i,y+j,_background);//  _background  -> _LayerBUF[index];

        }
    }
    if ((w + 2) < hor) char_x += w + 2;                  // x offset to next char 
    else               char_x += hor;
}

void WatchDisp::Symbol(unsigned int x, unsigned int y, unsigned char *symbol)
{
    unsigned int hor,vert,bpl,j,i,b; 
    unsigned char* zeichen;
    unsigned char z,w;
    
//    int index;
    hor = symbol[0];                       // get hor size of font
    vert = symbol[1];                      // get vert size of font
    bpl = symbol[2];                       // bytes per line

    if (char_x + hor > _width) {
        char_x = 0;
        char_y = char_y + vert;
        if (char_y >= _height - symbol[1]) char_y = 0; 
    }
    zeichen = &symbol[3]; 
    w = zeichen[0];                          // width of actual char
    for (j=0; j<vert; j++) {  //  vert line
        for (i=0; i<hor; i++) {   //  horz line
            z =  zeichen[bpl * i + ((j & 0xF8) >> 3)+1];
            b = 1 << (j & 0x07);
//            index = (y+j)*_width+(x+i);
            if (( z & b ) != 0x00)  pixel(x+i,y+j,_foreground);
            else if (_ifMarge == 0) pixel(x+i,y+j,_background);//  _background  -> _LayerBUF[index];
        }   
    }
    if ((w + 2) < hor) char_x += w + 2;                  // x offset to next char 
    else               char_x += hor;
}

void WatchDisp::pixel(int x, int y, uint8_t color)
{
        if(!(x % 2)) _dispBUF[y*_width/2+x/2] =  _dispBUF[y*_width/2+x/2]&0x0F  |  (color << 4)&0xF0 ;   //MASK 0000 1111
        else         _dispBUF[y*_width/2+x/2] =  _dispBUF[y*_width/2+x/2]&0xF0  |  (color     )&0x0F ;   //MASK 1111 0000
}

void WatchDisp::LayerCopy(void)
{
    for(int i=0; i<FRAME_SIZE; i++) _LayerBUF[i] = _dispBUF[i];
        
}

void WatchDisp::circle(int x0, int y0, int r, uint8_t color)
{
    int x = -r, y = 0, err = 2-2*r, e2;
    do {
        pixel(x0-x, y0+y,color);
        pixel(x0+x, y0+y,color);
        pixel(x0+x, y0-y,color);
        pixel(x0-x, y0-y,color);
        e2 = err;
        if (e2 <= y) {
            err += ++y*2+1;
            if (-x == y && e2 <= x) e2 = 0;
        }
        if (e2 > x) err += ++x*2+1;
    } while (x <= 0);

}
void WatchDisp::fillcircle(int x0, int y0, int r, uint8_t color)
{
    int x = -r, y = 0, err = 2-2*r, e2;
    do {
        vline(x0-x, y0-y, y0+y, color);
        vline(x0+x, y0-y, y0+y, color);
        e2 = err;
        if (e2 <= y) {
            err += ++y*2+1;
            if (-x == y && e2 <= x) e2 = 0;
        }
        if (e2 > x) err += ++x*2+1;
    } while (x <= 0);
}

void WatchDisp::hline(int x0, int x1, int y, uint8_t color)
{
    int w;
    w = x1 - x0 + 1;
    for (int j=0; j<w; j++) pixel(x0+j, y,color); 
}

void WatchDisp::vline(int x, int y0, int y1, uint8_t color)
{
    int h;
    h = y1 - y0 + 1;
    for (int j=0; j<h; j++) pixel(x, y0+j,color); 
}

void WatchDisp::line(int x0, int y0, int x1, int y1, uint8_t color)
{
    int   dx = 0, dy = 0;
    int   dx_sym = 0, dy_sym = 0;
    int   dx_x2 = 0, dy_x2 = 0;
    int   di = 0;

    dx = x1-x0;
    dy = y1-y0;

    if (dx == 0) {        /* vertical line */
        if (y1 > y0) vline(x0,y0,y1,color);
        else vline(x0,y1,y0,color);
        return;
    }

    if (dx > 0) {
        dx_sym = 1;
    } else {
        dx_sym = -1;
    }
    if (dy == 0) {        /* horizontal line */
        if (x1 > x0) hline(x0,x1,y0,color);
        else  hline(x1,x0,y0,color);
        return;
    }

    if (dy > 0) {
        dy_sym = 1;
    } else {
        dy_sym = -1;
    }

    dx = dx_sym*dx;
    dy = dy_sym*dy;

    dx_x2 = dx*2;
    dy_x2 = dy*2;

    if (dx >= dy) {
        di = dy_x2 - dx;
        while (x0 != x1) {

            pixel(x0, y0, color);
            x0 += dx_sym;
            if (di<0) {
                di += dy_x2;
            } else {
                di += dy_x2 - dx_x2;
                y0 += dy_sym;
            }
        }
        pixel(x0, y0, color);
    } else {
        di = dx_x2 - dy;
        while (y0 != y1) {
            pixel(x0, y0, color);
            y0 += dy_sym;
            if (di < 0) {
                di += dx_x2;
            } else {
                di += dx_x2 - dy_x2;
                x0 += dx_sym;
            }
        }
        pixel(x0, y0, color);
    }
    return;
}

void WatchDisp::rect(int x0, int y0, int x1, int y1, uint8_t color)
{

    if (x1 > x0) hline(x0,x1,y0,color);
    else  hline(x1,x0,y0,color);

    if (y1 > y0) vline(x0,y0,y1,color);
    else vline(x0,y1,y0,color);

    if (x1 > x0) hline(x0,x1,y1,color);
    else  hline(x1,x0,y1,color);

    if (y1 > y0) vline(x1,y0,y1,color);
    else vline(x1,y1,y0,color);

    return;
}

void WatchDisp::fillrect(int x0, int y0, int x1, int y1, uint8_t color)
{
    int h = y1 - y0 + 1;
    for (int i=0; i<h; i++) hline(x0, x1, y0+i, color);
}

void WatchDisp::writeDISP(void) {  // refresh whole display

    char pol = 0;
    char command = 0x80; // 8b 1*0xNNNN *=POL x=AutoW
    
    // frame 
    for (unsigned char i=0; i<_height; i++) { 
        // line
        wait_us(6);
        _cs  = 1;
        wait_us(6);
        _spi_write(command | (pol << 6) | (_if16 << 4) ); // COMMAND
        _spi_write(i+1); // V ADDR
        for(int j=0; j<_width/2; j++) _spi_write(_dispBUF[i*_width/2 + j]);
        _spi_write(0x00); // DUMMY transfer
        _spi_write(0x00); // DUMMY transfer
//        wait_ms(1);      //1.8Hz simulation
        wait_us(6);
        _cs  = 0;
        if(pol) pol=0x00;
        else    pol=0x01;
    }
}

void WatchDisp::clsBUF(void) {
    
    for (int i=0; i<_height; i++) {
         for (int j=0; j<_width; j++) {
            pixel(j,i,_background);
        }
    } 
}

void WatchDisp::foreground(uint8_t colour) {
    _foreground = colour;
}

void WatchDisp::background(uint8_t colour) {
    _background = colour;
}

void WatchDisp::setmarge(bool ifMarge) {
    _ifMarge = ifMarge;
}

void WatchDisp::setWH(int width, int height){
    _width  = width;
    _height = height;    
}

void WatchDisp::set16col(char if16) {
    _if16 = if16;
}

void WatchDisp::command(char command)  {
    wait_us(6);
    _cs  = 1;    
    wait_us(6);
    _spi_write(command);// 
    _spi_write(0x00);// dummy
    wait_us(6);
    _cs  = 0; 
}